/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.allocation_explain;

import co.elastic.clients.elasticsearch.cluster.allocation_explain.AllocationExplainDecision;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class AllocationDecision
implements JsonpSerializable {
    private final String decider;
    private final AllocationExplainDecision decision;
    private final String explanation;
    public static final JsonpDeserializer<AllocationDecision> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AllocationDecision::setupAllocationDecisionDeserializer, Builder::build);

    public AllocationDecision(Builder builder) {
        this.decider = Objects.requireNonNull(builder.decider, "decider");
        this.decision = Objects.requireNonNull(builder.decision, "decision");
        this.explanation = Objects.requireNonNull(builder.explanation, "explanation");
    }

    public AllocationDecision(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String decider() {
        return this.decider;
    }

    public AllocationExplainDecision decision() {
        return this.decision;
    }

    public String explanation() {
        return this.explanation;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("decider");
        generator.write(this.decider);
        generator.writeKey("decision");
        this.decision.serialize(generator, mapper);
        generator.writeKey("explanation");
        generator.write(this.explanation);
    }

    protected static void setupAllocationDecisionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::decider, JsonpDeserializer.stringDeserializer(), "decider", new String[0]);
        op.add(Builder::decision, AllocationExplainDecision._DESERIALIZER, "decision", new String[0]);
        op.add(Builder::explanation, JsonpDeserializer.stringDeserializer(), "explanation", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AllocationDecision> {
        private String decider;
        private AllocationExplainDecision decision;
        private String explanation;

        public Builder decider(String value) {
            this.decider = value;
            return this;
        }

        public Builder decision(AllocationExplainDecision value) {
            this.decision = value;
            return this;
        }

        public Builder explanation(String value) {
            this.explanation = value;
            return this;
        }

        @Override
        public AllocationDecision build() {
            return new AllocationDecision(this);
        }
    }
}

