/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch.cluster.reroute.RerouteExplanation;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RerouteResponse
implements JsonpSerializable {
    @Nullable
    private final List<RerouteExplanation> explanations;
    private final JsonData state;
    public static final JsonpDeserializer<RerouteResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RerouteResponse::setupRerouteResponseDeserializer, Builder::build);

    public RerouteResponse(Builder builder) {
        this.explanations = ModelTypeHelper.unmodifiable(builder.explanations);
        this.state = Objects.requireNonNull(builder.state, "state");
    }

    public RerouteResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<RerouteExplanation> explanations() {
        return this.explanations;
    }

    public JsonData state() {
        return this.state;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.explanations != null) {
            generator.writeKey("explanations");
            generator.writeStartArray();
            for (RerouteExplanation item0 : this.explanations) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
    }

    protected static void setupRerouteResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::explanations, JsonpDeserializer.arrayDeserializer(RerouteExplanation._DESERIALIZER), "explanations", new String[0]);
        op.add(Builder::state, JsonData._DESERIALIZER, "state", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RerouteResponse> {
        @Nullable
        private List<RerouteExplanation> explanations;
        private JsonData state;

        public Builder explanations(@Nullable List<RerouteExplanation> value) {
            this.explanations = value;
            return this;
        }

        public Builder explanations(RerouteExplanation ... value) {
            this.explanations = Arrays.asList(value);
            return this;
        }

        public Builder addExplanations(RerouteExplanation value) {
            if (this.explanations == null) {
                this.explanations = new ArrayList<RerouteExplanation>();
            }
            this.explanations.add(value);
            return this;
        }

        public Builder explanations(Function<RerouteExplanation.Builder, ObjectBuilder<RerouteExplanation>> fn) {
            return this.explanations(fn.apply(new RerouteExplanation.Builder()).build());
        }

        public Builder addExplanations(Function<RerouteExplanation.Builder, ObjectBuilder<RerouteExplanation>> fn) {
            return this.addExplanations(fn.apply(new RerouteExplanation.Builder()).build());
        }

        public Builder state(JsonData value) {
            this.state = value;
            return this;
        }

        @Override
        public RerouteResponse build() {
            return new RerouteResponse(this);
        }
    }
}

