/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.base.BooleanEndpoint;
import co.elastic.clients.base.BooleanResponse;
import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class PostVotingConfigExclusionsRequest
extends RequestBase {
    @Nullable
    private final List<String> nodeNames;
    @Nullable
    private final List<String> nodeIds;
    @Nullable
    private final String timeout;
    public static final Endpoint<PostVotingConfigExclusionsRequest, BooleanResponse, ElasticsearchError> ENDPOINT = new BooleanEndpoint<PostVotingConfigExclusionsRequest>(request -> "POST", request -> "/_cluster/voting_config_exclusions", (Function<PostVotingConfigExclusionsRequest, Map<String, String>>)((Function<PostVotingConfigExclusionsRequest, Map>)request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.nodeNames != null) {
            params.put("node_names", request.nodeNames.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.nodeIds != null) {
            params.put("node_ids", request.nodeIds.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }), (Function<PostVotingConfigExclusionsRequest, Map<String, String>>)SimpleEndpoint.emptyMap(), false, null);

    public PostVotingConfigExclusionsRequest(Builder builder) {
        this.nodeNames = ModelTypeHelper.unmodifiable(builder.nodeNames);
        this.nodeIds = ModelTypeHelper.unmodifiable(builder.nodeIds);
        this.timeout = builder.timeout;
    }

    public PostVotingConfigExclusionsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> nodeNames() {
        return this.nodeNames;
    }

    @Nullable
    public List<String> nodeIds() {
        return this.nodeIds;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    public static class Builder
    implements ObjectBuilder<PostVotingConfigExclusionsRequest> {
        @Nullable
        private List<String> nodeNames;
        @Nullable
        private List<String> nodeIds;
        @Nullable
        private String timeout;

        public Builder nodeNames(@Nullable List<String> value) {
            this.nodeNames = value;
            return this;
        }

        public Builder nodeNames(String ... value) {
            this.nodeNames = Arrays.asList(value);
            return this;
        }

        public Builder addNodeNames(String value) {
            if (this.nodeNames == null) {
                this.nodeNames = new ArrayList<String>();
            }
            this.nodeNames.add(value);
            return this;
        }

        public Builder nodeIds(@Nullable List<String> value) {
            this.nodeIds = value;
            return this;
        }

        public Builder nodeIds(String ... value) {
            this.nodeIds = Arrays.asList(value);
            return this;
        }

        public Builder addNodeIds(String value) {
            if (this.nodeIds == null) {
                this.nodeIds = new ArrayList<String>();
            }
            this.nodeIds.add(value);
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public PostVotingConfigExclusionsRequest build() {
            return new PostVotingConfigExclusionsRequest(this);
        }
    }
}

