/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch._types.Health;
import co.elastic.clients.elasticsearch.cluster.health.IndexHealthStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class HealthResponse
implements JsonpSerializable {
    private final int activePrimaryShards;
    private final int activeShards;
    private final String activeShardsPercentAsNumber;
    private final String clusterName;
    private final int delayedUnassignedShards;
    @Nullable
    private final Map<String, IndexHealthStats> indices;
    private final int initializingShards;
    private final int numberOfDataNodes;
    private final int numberOfInFlightFetch;
    private final int numberOfNodes;
    private final int numberOfPendingTasks;
    private final int relocatingShards;
    private final Health status;
    private final String taskMaxWaitingInQueueMillis;
    private final boolean timedOut;
    private final int unassignedShards;
    public static final JsonpDeserializer<HealthResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HealthResponse::setupHealthResponseDeserializer, Builder::build);

    public HealthResponse(Builder builder) {
        this.activePrimaryShards = Objects.requireNonNull(builder.activePrimaryShards, "active_primary_shards");
        this.activeShards = Objects.requireNonNull(builder.activeShards, "active_shards");
        this.activeShardsPercentAsNumber = Objects.requireNonNull(builder.activeShardsPercentAsNumber, "active_shards_percent_as_number");
        this.clusterName = Objects.requireNonNull(builder.clusterName, "cluster_name");
        this.delayedUnassignedShards = Objects.requireNonNull(builder.delayedUnassignedShards, "delayed_unassigned_shards");
        this.indices = ModelTypeHelper.unmodifiable(builder.indices);
        this.initializingShards = Objects.requireNonNull(builder.initializingShards, "initializing_shards");
        this.numberOfDataNodes = Objects.requireNonNull(builder.numberOfDataNodes, "number_of_data_nodes");
        this.numberOfInFlightFetch = Objects.requireNonNull(builder.numberOfInFlightFetch, "number_of_in_flight_fetch");
        this.numberOfNodes = Objects.requireNonNull(builder.numberOfNodes, "number_of_nodes");
        this.numberOfPendingTasks = Objects.requireNonNull(builder.numberOfPendingTasks, "number_of_pending_tasks");
        this.relocatingShards = Objects.requireNonNull(builder.relocatingShards, "relocating_shards");
        this.status = Objects.requireNonNull(builder.status, "status");
        this.taskMaxWaitingInQueueMillis = Objects.requireNonNull(builder.taskMaxWaitingInQueueMillis, "task_max_waiting_in_queue_millis");
        this.timedOut = Objects.requireNonNull(builder.timedOut, "timed_out");
        this.unassignedShards = Objects.requireNonNull(builder.unassignedShards, "unassigned_shards");
    }

    public HealthResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int activePrimaryShards() {
        return this.activePrimaryShards;
    }

    public int activeShards() {
        return this.activeShards;
    }

    public String activeShardsPercentAsNumber() {
        return this.activeShardsPercentAsNumber;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public int delayedUnassignedShards() {
        return this.delayedUnassignedShards;
    }

    @Nullable
    public Map<String, IndexHealthStats> indices() {
        return this.indices;
    }

    public int initializingShards() {
        return this.initializingShards;
    }

    public int numberOfDataNodes() {
        return this.numberOfDataNodes;
    }

    public int numberOfInFlightFetch() {
        return this.numberOfInFlightFetch;
    }

    public int numberOfNodes() {
        return this.numberOfNodes;
    }

    public int numberOfPendingTasks() {
        return this.numberOfPendingTasks;
    }

    public int relocatingShards() {
        return this.relocatingShards;
    }

    public Health status() {
        return this.status;
    }

    public String taskMaxWaitingInQueueMillis() {
        return this.taskMaxWaitingInQueueMillis;
    }

    public boolean timedOut() {
        return this.timedOut;
    }

    public int unassignedShards() {
        return this.unassignedShards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("active_primary_shards");
        generator.write(this.activePrimaryShards);
        generator.writeKey("active_shards");
        generator.write(this.activeShards);
        generator.writeKey("active_shards_percent_as_number");
        generator.write(this.activeShardsPercentAsNumber);
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        generator.writeKey("delayed_unassigned_shards");
        generator.write(this.delayedUnassignedShards);
        if (this.indices != null) {
            generator.writeKey("indices");
            generator.writeStartObject();
            for (Map.Entry<String, IndexHealthStats> item0 : this.indices.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("initializing_shards");
        generator.write(this.initializingShards);
        generator.writeKey("number_of_data_nodes");
        generator.write(this.numberOfDataNodes);
        generator.writeKey("number_of_in_flight_fetch");
        generator.write(this.numberOfInFlightFetch);
        generator.writeKey("number_of_nodes");
        generator.write(this.numberOfNodes);
        generator.writeKey("number_of_pending_tasks");
        generator.write(this.numberOfPendingTasks);
        generator.writeKey("relocating_shards");
        generator.write(this.relocatingShards);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("task_max_waiting_in_queue_millis");
        generator.write(this.taskMaxWaitingInQueueMillis);
        generator.writeKey("timed_out");
        generator.write(this.timedOut);
        generator.writeKey("unassigned_shards");
        generator.write(this.unassignedShards);
    }

    protected static void setupHealthResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::activePrimaryShards, JsonpDeserializer.integerDeserializer(), "active_primary_shards", new String[0]);
        op.add(Builder::activeShards, JsonpDeserializer.integerDeserializer(), "active_shards", new String[0]);
        op.add(Builder::activeShardsPercentAsNumber, JsonpDeserializer.stringDeserializer(), "active_shards_percent_as_number", new String[0]);
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name", new String[0]);
        op.add(Builder::delayedUnassignedShards, JsonpDeserializer.integerDeserializer(), "delayed_unassigned_shards", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(IndexHealthStats._DESERIALIZER), "indices", new String[0]);
        op.add(Builder::initializingShards, JsonpDeserializer.integerDeserializer(), "initializing_shards", new String[0]);
        op.add(Builder::numberOfDataNodes, JsonpDeserializer.integerDeserializer(), "number_of_data_nodes", new String[0]);
        op.add(Builder::numberOfInFlightFetch, JsonpDeserializer.integerDeserializer(), "number_of_in_flight_fetch", new String[0]);
        op.add(Builder::numberOfNodes, JsonpDeserializer.integerDeserializer(), "number_of_nodes", new String[0]);
        op.add(Builder::numberOfPendingTasks, JsonpDeserializer.integerDeserializer(), "number_of_pending_tasks", new String[0]);
        op.add(Builder::relocatingShards, JsonpDeserializer.integerDeserializer(), "relocating_shards", new String[0]);
        op.add(Builder::status, Health._DESERIALIZER, "status", new String[0]);
        op.add(Builder::taskMaxWaitingInQueueMillis, JsonpDeserializer.stringDeserializer(), "task_max_waiting_in_queue_millis", new String[0]);
        op.add(Builder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out", new String[0]);
        op.add(Builder::unassignedShards, JsonpDeserializer.integerDeserializer(), "unassigned_shards", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<HealthResponse> {
        private Integer activePrimaryShards;
        private Integer activeShards;
        private String activeShardsPercentAsNumber;
        private String clusterName;
        private Integer delayedUnassignedShards;
        @Nullable
        private Map<String, IndexHealthStats> indices;
        private Integer initializingShards;
        private Integer numberOfDataNodes;
        private Integer numberOfInFlightFetch;
        private Integer numberOfNodes;
        private Integer numberOfPendingTasks;
        private Integer relocatingShards;
        private Health status;
        private String taskMaxWaitingInQueueMillis;
        private Boolean timedOut;
        private Integer unassignedShards;

        public Builder activePrimaryShards(int value) {
            this.activePrimaryShards = value;
            return this;
        }

        public Builder activeShards(int value) {
            this.activeShards = value;
            return this;
        }

        public Builder activeShardsPercentAsNumber(String value) {
            this.activeShardsPercentAsNumber = value;
            return this;
        }

        public Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        public Builder delayedUnassignedShards(int value) {
            this.delayedUnassignedShards = value;
            return this;
        }

        public Builder indices(@Nullable Map<String, IndexHealthStats> value) {
            this.indices = value;
            return this;
        }

        public Builder putIndices(String key, IndexHealthStats value) {
            if (this.indices == null) {
                this.indices = new HashMap<String, IndexHealthStats>();
            }
            this.indices.put(key, value);
            return this;
        }

        public Builder indices(String key, Function<IndexHealthStats.Builder, ObjectBuilder<IndexHealthStats>> fn) {
            return this.indices(Collections.singletonMap(key, fn.apply(new IndexHealthStats.Builder()).build()));
        }

        public Builder putIndices(String key, Function<IndexHealthStats.Builder, ObjectBuilder<IndexHealthStats>> fn) {
            return this.putIndices(key, fn.apply(new IndexHealthStats.Builder()).build());
        }

        public Builder initializingShards(int value) {
            this.initializingShards = value;
            return this;
        }

        public Builder numberOfDataNodes(int value) {
            this.numberOfDataNodes = value;
            return this;
        }

        public Builder numberOfInFlightFetch(int value) {
            this.numberOfInFlightFetch = value;
            return this;
        }

        public Builder numberOfNodes(int value) {
            this.numberOfNodes = value;
            return this;
        }

        public Builder numberOfPendingTasks(int value) {
            this.numberOfPendingTasks = value;
            return this;
        }

        public Builder relocatingShards(int value) {
            this.relocatingShards = value;
            return this;
        }

        public Builder status(Health value) {
            this.status = value;
            return this;
        }

        public Builder taskMaxWaitingInQueueMillis(String value) {
            this.taskMaxWaitingInQueueMillis = value;
            return this;
        }

        public Builder timedOut(boolean value) {
            this.timedOut = value;
            return this;
        }

        public Builder unassignedShards(int value) {
            this.unassignedShards = value;
            return this;
        }

        @Override
        public HealthResponse build() {
            return new HealthResponse(this);
        }
    }
}

