/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.elasticsearch.ccr.stats.AutoFollowStats;
import co.elastic.clients.elasticsearch.ccr.stats.FollowStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class StatsResponse
implements JsonpSerializable {
    private final AutoFollowStats autoFollowStats;
    private final FollowStats followStats;
    public static final JsonpDeserializer<StatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StatsResponse::setupStatsResponseDeserializer, Builder::build);

    public StatsResponse(Builder builder) {
        this.autoFollowStats = Objects.requireNonNull(builder.autoFollowStats, "auto_follow_stats");
        this.followStats = Objects.requireNonNull(builder.followStats, "follow_stats");
    }

    public StatsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public AutoFollowStats autoFollowStats() {
        return this.autoFollowStats;
    }

    public FollowStats followStats() {
        return this.followStats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("auto_follow_stats");
        this.autoFollowStats.serialize(generator, mapper);
        generator.writeKey("follow_stats");
        this.followStats.serialize(generator, mapper);
    }

    protected static void setupStatsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::autoFollowStats, AutoFollowStats._DESERIALIZER, "auto_follow_stats", new String[0]);
        op.add(Builder::followStats, FollowStats._DESERIALIZER, "follow_stats", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<StatsResponse> {
        private AutoFollowStats autoFollowStats;
        private FollowStats followStats;

        public Builder autoFollowStats(AutoFollowStats value) {
            this.autoFollowStats = value;
            return this;
        }

        public Builder autoFollowStats(Function<AutoFollowStats.Builder, ObjectBuilder<AutoFollowStats>> fn) {
            return this.autoFollowStats(fn.apply(new AutoFollowStats.Builder()).build());
        }

        public Builder followStats(FollowStats value) {
            this.followStats = value;
            return this;
        }

        public Builder followStats(Function<FollowStats.Builder, ObjectBuilder<FollowStats>> fn) {
            return this.followStats(fn.apply(new FollowStats.Builder()).build());
        }

        @Override
        public StatsResponse build() {
            return new StatsResponse(this);
        }
    }
}

