/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ccr.PutAutoFollowPatternResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutAutoFollowPatternRequest
extends RequestBase
implements JsonpSerializable {
    private final String name;
    private final String remoteCluster;
    @Nullable
    private final String followIndexPattern;
    @Nullable
    private final List<String> leaderIndexPatterns;
    @Nullable
    private final List<String> leaderIndexExclusionPatterns;
    @Nullable
    private final Integer maxOutstandingReadRequests;
    @Nullable
    private final Map<String, JsonData> settings;
    @Nullable
    private final Integer maxOutstandingWriteRequests;
    @Nullable
    private final String readPollTimeout;
    @Nullable
    private final Integer maxReadRequestOperationCount;
    @Nullable
    private final String maxReadRequestSize;
    @Nullable
    private final String maxRetryDelay;
    @Nullable
    private final Integer maxWriteBufferCount;
    @Nullable
    private final String maxWriteBufferSize;
    @Nullable
    private final Integer maxWriteRequestOperationCount;
    @Nullable
    private final String maxWriteRequestSize;
    public static final JsonpDeserializer<PutAutoFollowPatternRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutAutoFollowPatternRequest::setupPutAutoFollowPatternRequestDeserializer, Builder::build);
    public static final Endpoint<PutAutoFollowPatternRequest, PutAutoFollowPatternResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutAutoFollowPatternRequest, PutAutoFollowPatternResponse>(request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ccr");
            buf.append("/auto_follow");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutAutoFollowPatternResponse._DESERIALIZER);

    public PutAutoFollowPatternRequest(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.remoteCluster = Objects.requireNonNull(builder.remoteCluster, "remote_cluster");
        this.followIndexPattern = builder.followIndexPattern;
        this.leaderIndexPatterns = ModelTypeHelper.unmodifiable(builder.leaderIndexPatterns);
        this.leaderIndexExclusionPatterns = ModelTypeHelper.unmodifiable(builder.leaderIndexExclusionPatterns);
        this.maxOutstandingReadRequests = builder.maxOutstandingReadRequests;
        this.settings = ModelTypeHelper.unmodifiable(builder.settings);
        this.maxOutstandingWriteRequests = builder.maxOutstandingWriteRequests;
        this.readPollTimeout = builder.readPollTimeout;
        this.maxReadRequestOperationCount = builder.maxReadRequestOperationCount;
        this.maxReadRequestSize = builder.maxReadRequestSize;
        this.maxRetryDelay = builder.maxRetryDelay;
        this.maxWriteBufferCount = builder.maxWriteBufferCount;
        this.maxWriteBufferSize = builder.maxWriteBufferSize;
        this.maxWriteRequestOperationCount = builder.maxWriteRequestOperationCount;
        this.maxWriteRequestSize = builder.maxWriteRequestSize;
    }

    public PutAutoFollowPatternRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    public String remoteCluster() {
        return this.remoteCluster;
    }

    @Nullable
    public String followIndexPattern() {
        return this.followIndexPattern;
    }

    @Nullable
    public List<String> leaderIndexPatterns() {
        return this.leaderIndexPatterns;
    }

    @Nullable
    public List<String> leaderIndexExclusionPatterns() {
        return this.leaderIndexExclusionPatterns;
    }

    @Nullable
    public Integer maxOutstandingReadRequests() {
        return this.maxOutstandingReadRequests;
    }

    @Nullable
    public Map<String, JsonData> settings() {
        return this.settings;
    }

    @Nullable
    public Integer maxOutstandingWriteRequests() {
        return this.maxOutstandingWriteRequests;
    }

    @Nullable
    public String readPollTimeout() {
        return this.readPollTimeout;
    }

    @Nullable
    public Integer maxReadRequestOperationCount() {
        return this.maxReadRequestOperationCount;
    }

    @Nullable
    public String maxReadRequestSize() {
        return this.maxReadRequestSize;
    }

    @Nullable
    public String maxRetryDelay() {
        return this.maxRetryDelay;
    }

    @Nullable
    public Integer maxWriteBufferCount() {
        return this.maxWriteBufferCount;
    }

    @Nullable
    public String maxWriteBufferSize() {
        return this.maxWriteBufferSize;
    }

    @Nullable
    public Integer maxWriteRequestOperationCount() {
        return this.maxWriteRequestOperationCount;
    }

    @Nullable
    public String maxWriteRequestSize() {
        return this.maxWriteRequestSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("remote_cluster");
        generator.write(this.remoteCluster);
        if (this.followIndexPattern != null) {
            generator.writeKey("follow_index_pattern");
            generator.write(this.followIndexPattern);
        }
        if (this.leaderIndexPatterns != null) {
            generator.writeKey("leader_index_patterns");
            generator.writeStartArray();
            for (String string : this.leaderIndexPatterns) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.leaderIndexExclusionPatterns != null) {
            generator.writeKey("leader_index_exclusion_patterns");
            generator.writeStartArray();
            for (String string : this.leaderIndexExclusionPatterns) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.maxOutstandingReadRequests != null) {
            generator.writeKey("max_outstanding_read_requests");
            generator.write(this.maxOutstandingReadRequests.intValue());
        }
        if (this.settings != null) {
            generator.writeKey("settings");
            generator.writeStartObject();
            for (Map.Entry entry : this.settings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxOutstandingWriteRequests != null) {
            generator.writeKey("max_outstanding_write_requests");
            generator.write(this.maxOutstandingWriteRequests.intValue());
        }
        if (this.readPollTimeout != null) {
            generator.writeKey("read_poll_timeout");
            generator.write(this.readPollTimeout);
        }
        if (this.maxReadRequestOperationCount != null) {
            generator.writeKey("max_read_request_operation_count");
            generator.write(this.maxReadRequestOperationCount.intValue());
        }
        if (this.maxReadRequestSize != null) {
            generator.writeKey("max_read_request_size");
            generator.write(this.maxReadRequestSize);
        }
        if (this.maxRetryDelay != null) {
            generator.writeKey("max_retry_delay");
            generator.write(this.maxRetryDelay);
        }
        if (this.maxWriteBufferCount != null) {
            generator.writeKey("max_write_buffer_count");
            generator.write(this.maxWriteBufferCount.intValue());
        }
        if (this.maxWriteBufferSize != null) {
            generator.writeKey("max_write_buffer_size");
            generator.write(this.maxWriteBufferSize);
        }
        if (this.maxWriteRequestOperationCount != null) {
            generator.writeKey("max_write_request_operation_count");
            generator.write(this.maxWriteRequestOperationCount.intValue());
        }
        if (this.maxWriteRequestSize != null) {
            generator.writeKey("max_write_request_size");
            generator.write(this.maxWriteRequestSize);
        }
    }

    protected static void setupPutAutoFollowPatternRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::remoteCluster, JsonpDeserializer.stringDeserializer(), "remote_cluster", new String[0]);
        op.add(Builder::followIndexPattern, JsonpDeserializer.stringDeserializer(), "follow_index_pattern", new String[0]);
        op.add(Builder::leaderIndexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "leader_index_patterns", new String[0]);
        op.add(Builder::leaderIndexExclusionPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "leader_index_exclusion_patterns", new String[0]);
        op.add(Builder::maxOutstandingReadRequests, JsonpDeserializer.integerDeserializer(), "max_outstanding_read_requests", new String[0]);
        op.add(Builder::settings, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "settings", new String[0]);
        op.add(Builder::maxOutstandingWriteRequests, JsonpDeserializer.integerDeserializer(), "max_outstanding_write_requests", new String[0]);
        op.add(Builder::readPollTimeout, JsonpDeserializer.stringDeserializer(), "read_poll_timeout", new String[0]);
        op.add(Builder::maxReadRequestOperationCount, JsonpDeserializer.integerDeserializer(), "max_read_request_operation_count", new String[0]);
        op.add(Builder::maxReadRequestSize, JsonpDeserializer.stringDeserializer(), "max_read_request_size", new String[0]);
        op.add(Builder::maxRetryDelay, JsonpDeserializer.stringDeserializer(), "max_retry_delay", new String[0]);
        op.add(Builder::maxWriteBufferCount, JsonpDeserializer.integerDeserializer(), "max_write_buffer_count", new String[0]);
        op.add(Builder::maxWriteBufferSize, JsonpDeserializer.stringDeserializer(), "max_write_buffer_size", new String[0]);
        op.add(Builder::maxWriteRequestOperationCount, JsonpDeserializer.integerDeserializer(), "max_write_request_operation_count", new String[0]);
        op.add(Builder::maxWriteRequestSize, JsonpDeserializer.stringDeserializer(), "max_write_request_size", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutAutoFollowPatternRequest> {
        private String name;
        private String remoteCluster;
        @Nullable
        private String followIndexPattern;
        @Nullable
        private List<String> leaderIndexPatterns;
        @Nullable
        private List<String> leaderIndexExclusionPatterns;
        @Nullable
        private Integer maxOutstandingReadRequests;
        @Nullable
        private Map<String, JsonData> settings;
        @Nullable
        private Integer maxOutstandingWriteRequests;
        @Nullable
        private String readPollTimeout;
        @Nullable
        private Integer maxReadRequestOperationCount;
        @Nullable
        private String maxReadRequestSize;
        @Nullable
        private String maxRetryDelay;
        @Nullable
        private Integer maxWriteBufferCount;
        @Nullable
        private String maxWriteBufferSize;
        @Nullable
        private Integer maxWriteRequestOperationCount;
        @Nullable
        private String maxWriteRequestSize;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder remoteCluster(String value) {
            this.remoteCluster = value;
            return this;
        }

        public Builder followIndexPattern(@Nullable String value) {
            this.followIndexPattern = value;
            return this;
        }

        public Builder leaderIndexPatterns(@Nullable List<String> value) {
            this.leaderIndexPatterns = value;
            return this;
        }

        public Builder leaderIndexPatterns(String ... value) {
            this.leaderIndexPatterns = Arrays.asList(value);
            return this;
        }

        public Builder addLeaderIndexPatterns(String value) {
            if (this.leaderIndexPatterns == null) {
                this.leaderIndexPatterns = new ArrayList<String>();
            }
            this.leaderIndexPatterns.add(value);
            return this;
        }

        public Builder leaderIndexExclusionPatterns(@Nullable List<String> value) {
            this.leaderIndexExclusionPatterns = value;
            return this;
        }

        public Builder leaderIndexExclusionPatterns(String ... value) {
            this.leaderIndexExclusionPatterns = Arrays.asList(value);
            return this;
        }

        public Builder addLeaderIndexExclusionPatterns(String value) {
            if (this.leaderIndexExclusionPatterns == null) {
                this.leaderIndexExclusionPatterns = new ArrayList<String>();
            }
            this.leaderIndexExclusionPatterns.add(value);
            return this;
        }

        public Builder maxOutstandingReadRequests(@Nullable Integer value) {
            this.maxOutstandingReadRequests = value;
            return this;
        }

        public Builder settings(@Nullable Map<String, JsonData> value) {
            this.settings = value;
            return this;
        }

        public Builder putSettings(String key, JsonData value) {
            if (this.settings == null) {
                this.settings = new HashMap<String, JsonData>();
            }
            this.settings.put(key, value);
            return this;
        }

        public Builder maxOutstandingWriteRequests(@Nullable Integer value) {
            this.maxOutstandingWriteRequests = value;
            return this;
        }

        public Builder readPollTimeout(@Nullable String value) {
            this.readPollTimeout = value;
            return this;
        }

        public Builder maxReadRequestOperationCount(@Nullable Integer value) {
            this.maxReadRequestOperationCount = value;
            return this;
        }

        public Builder maxReadRequestSize(@Nullable String value) {
            this.maxReadRequestSize = value;
            return this;
        }

        public Builder maxRetryDelay(@Nullable String value) {
            this.maxRetryDelay = value;
            return this;
        }

        public Builder maxWriteBufferCount(@Nullable Integer value) {
            this.maxWriteBufferCount = value;
            return this;
        }

        public Builder maxWriteBufferSize(@Nullable String value) {
            this.maxWriteBufferSize = value;
            return this;
        }

        public Builder maxWriteRequestOperationCount(@Nullable Integer value) {
            this.maxWriteRequestOperationCount = value;
            return this;
        }

        public Builder maxWriteRequestSize(@Nullable String value) {
            this.maxWriteRequestSize = value;
            return this;
        }

        @Override
        public PutAutoFollowPatternRequest build() {
            return new PutAutoFollowPatternRequest(this);
        }
    }
}

