/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.elasticsearch.ccr.follow_info.FollowerIndex;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class FollowInfoResponse
implements JsonpSerializable {
    private final List<FollowerIndex> followerIndices;
    public static final JsonpDeserializer<FollowInfoResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FollowInfoResponse::setupFollowInfoResponseDeserializer, Builder::build);

    public FollowInfoResponse(Builder builder) {
        this.followerIndices = ModelTypeHelper.unmodifiableNonNull(builder.followerIndices, "follower_indices");
    }

    public FollowInfoResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<FollowerIndex> followerIndices() {
        return this.followerIndices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("follower_indices");
        generator.writeStartArray();
        for (FollowerIndex item0 : this.followerIndices) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupFollowInfoResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::followerIndices, JsonpDeserializer.arrayDeserializer(FollowerIndex._DESERIALIZER), "follower_indices", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FollowInfoResponse> {
        private List<FollowerIndex> followerIndices;

        public Builder followerIndices(List<FollowerIndex> value) {
            this.followerIndices = value;
            return this;
        }

        public Builder followerIndices(FollowerIndex ... value) {
            this.followerIndices = Arrays.asList(value);
            return this;
        }

        public Builder addFollowerIndices(FollowerIndex value) {
            if (this.followerIndices == null) {
                this.followerIndices = new ArrayList<FollowerIndex>();
            }
            this.followerIndices.add(value);
            return this;
        }

        public Builder followerIndices(Function<FollowerIndex.Builder, ObjectBuilder<FollowerIndex>> fn) {
            return this.followerIndices(fn.apply(new FollowerIndex.Builder()).build());
        }

        public Builder addFollowerIndices(Function<FollowerIndex.Builder, ObjectBuilder<FollowerIndex>> fn) {
            return this.addFollowerIndices(fn.apply(new FollowerIndex.Builder()).build());
        }

        @Override
        public FollowInfoResponse build() {
            return new FollowInfoResponse(this);
        }
    }
}

