/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.SnapshotsResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class SnapshotsRequest
extends CatRequestBase {
    @Nullable
    private final List<String> repository;
    @Nullable
    private final Boolean ignoreUnavailable;
    public static final Endpoint<SnapshotsRequest, SnapshotsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<SnapshotsRequest, SnapshotsResponse>(request -> "GET", request -> {
        boolean _repository = true;
        boolean propsSet = false;
        if (request.repository() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/snapshots");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/snapshots");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, SnapshotsResponse._DESERIALIZER);

    public SnapshotsRequest(Builder builder) {
        this.repository = ModelTypeHelper.unmodifiable(builder.repository);
        this.ignoreUnavailable = builder.ignoreUnavailable;
    }

    public SnapshotsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> repository() {
        return this.repository;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public static class Builder
    implements ObjectBuilder<SnapshotsRequest> {
        @Nullable
        private List<String> repository;
        @Nullable
        private Boolean ignoreUnavailable;

        public Builder repository(@Nullable List<String> value) {
            this.repository = value;
            return this;
        }

        public Builder repository(String ... value) {
            this.repository = Arrays.asList(value);
            return this;
        }

        public Builder addRepository(String value) {
            if (this.repository == null) {
                this.repository = new ArrayList<String>();
            }
            this.repository.add(value);
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        @Override
        public SnapshotsRequest build() {
            return new SnapshotsRequest(this);
        }
    }
}

