/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.NodesResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class NodesRequest
extends CatRequestBase {
    @Nullable
    private final Bytes bytes;
    @Nullable
    private final Boolean fullId;
    public static final Endpoint<NodesRequest, NodesResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<NodesRequest, NodesResponse>(request -> "GET", request -> "/_cat/nodes", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.bytes != null) {
            params.put("bytes", request.bytes.toString());
        }
        if (request.fullId != null) {
            params.put("full_id", String.valueOf(request.fullId));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, NodesResponse._DESERIALIZER);

    public NodesRequest(Builder builder) {
        this.bytes = builder.bytes;
        this.fullId = builder.fullId;
    }

    public NodesRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Bytes bytes() {
        return this.bytes;
    }

    @Nullable
    public Boolean fullId() {
        return this.fullId;
    }

    public static class Builder
    implements ObjectBuilder<NodesRequest> {
        @Nullable
        private Bytes bytes;
        @Nullable
        private Boolean fullId;

        public Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public Builder fullId(@Nullable Boolean value) {
            this.fullId = value;
            return this;
        }

        @Override
        public NodesRequest build() {
            return new NodesRequest(this);
        }
    }
}

