/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.MlDatafeedsResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class MlDatafeedsRequest
extends CatRequestBase {
    @Nullable
    private final String datafeedId;
    @Nullable
    private final Boolean allowNoDatafeeds;
    public static final Endpoint<MlDatafeedsRequest, MlDatafeedsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<MlDatafeedsRequest, MlDatafeedsResponse>(request -> "GET", request -> {
        boolean _datafeedId = true;
        boolean propsSet = false;
        if (request.datafeedId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/datafeeds");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/datafeeds");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.datafeedId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoDatafeeds != null) {
            params.put("allow_no_datafeeds", String.valueOf(request.allowNoDatafeeds));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, MlDatafeedsResponse._DESERIALIZER);

    public MlDatafeedsRequest(Builder builder) {
        this.datafeedId = builder.datafeedId;
        this.allowNoDatafeeds = builder.allowNoDatafeeds;
    }

    public MlDatafeedsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String datafeedId() {
        return this.datafeedId;
    }

    @Nullable
    public Boolean allowNoDatafeeds() {
        return this.allowNoDatafeeds;
    }

    public static class Builder
    implements ObjectBuilder<MlDatafeedsRequest> {
        @Nullable
        private String datafeedId;
        @Nullable
        private Boolean allowNoDatafeeds;

        public Builder datafeedId(@Nullable String value) {
            this.datafeedId = value;
            return this;
        }

        public Builder allowNoDatafeeds(@Nullable Boolean value) {
            this.allowNoDatafeeds = value;
            return this;
        }

        @Override
        public MlDatafeedsRequest build() {
            return new MlDatafeedsRequest(this);
        }
    }
}

