/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch.cat.health.HealthRecord;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class HealthResponse
implements JsonpSerializable {
    private final List<HealthRecord> valueBody;
    public static final JsonpDeserializer<HealthResponse> _DESERIALIZER = HealthResponse.createHealthResponseDeserializer();

    public HealthResponse(Builder builder) {
        this.valueBody = ModelTypeHelper.unmodifiableNonNull(builder.valueBody, "_value_body");
    }

    public HealthResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<HealthRecord> valueBody() {
        return this.valueBody;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (HealthRecord item0 : this.valueBody) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static JsonpDeserializer<HealthResponse> createHealthResponseDeserializer() {
        JsonpDeserializer<List<HealthRecord>> valueDeserializer = JsonpDeserializer.arrayDeserializer(HealthRecord._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().valueBody((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    implements ObjectBuilder<HealthResponse> {
        private List<HealthRecord> valueBody;

        public Builder valueBody(List<HealthRecord> value) {
            this.valueBody = value;
            return this;
        }

        public Builder valueBody(HealthRecord ... value) {
            this.valueBody = Arrays.asList(value);
            return this;
        }

        public Builder addValueBody(HealthRecord value) {
            if (this.valueBody == null) {
                this.valueBody = new ArrayList<HealthRecord>();
            }
            this.valueBody.add(value);
            return this;
        }

        public Builder valueBody(Function<HealthRecord.Builder, ObjectBuilder<HealthRecord>> fn) {
            return this.valueBody(fn.apply(new HealthRecord.Builder()).build());
        }

        public Builder addValueBody(Function<HealthRecord.Builder, ObjectBuilder<HealthRecord>> fn) {
            return this.addValueBody(fn.apply(new HealthRecord.Builder()).build());
        }

        @Override
        public HealthResponse build() {
            return new HealthResponse(this);
        }
    }
}

