/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.autoscaling.get_autoscaling_capacity;

import co.elastic.clients.elasticsearch.autoscaling.get_autoscaling_capacity.AutoscalingCapacity;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AutoscalingDecider
implements JsonpSerializable {
    private final AutoscalingCapacity requiredCapacity;
    @Nullable
    private final String reasonSummary;
    @Nullable
    private final JsonData reasonDetails;
    public static final JsonpDeserializer<AutoscalingDecider> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AutoscalingDecider::setupAutoscalingDeciderDeserializer, Builder::build);

    public AutoscalingDecider(Builder builder) {
        this.requiredCapacity = Objects.requireNonNull(builder.requiredCapacity, "required_capacity");
        this.reasonSummary = builder.reasonSummary;
        this.reasonDetails = builder.reasonDetails;
    }

    public AutoscalingDecider(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public AutoscalingCapacity requiredCapacity() {
        return this.requiredCapacity;
    }

    @Nullable
    public String reasonSummary() {
        return this.reasonSummary;
    }

    @Nullable
    public JsonData reasonDetails() {
        return this.reasonDetails;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("required_capacity");
        this.requiredCapacity.serialize(generator, mapper);
        if (this.reasonSummary != null) {
            generator.writeKey("reason_summary");
            generator.write(this.reasonSummary);
        }
        if (this.reasonDetails != null) {
            generator.writeKey("reason_details");
            this.reasonDetails.serialize(generator, mapper);
        }
    }

    protected static void setupAutoscalingDeciderDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::requiredCapacity, AutoscalingCapacity._DESERIALIZER, "required_capacity", new String[0]);
        op.add(Builder::reasonSummary, JsonpDeserializer.stringDeserializer(), "reason_summary", new String[0]);
        op.add(Builder::reasonDetails, JsonData._DESERIALIZER, "reason_details", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AutoscalingDecider> {
        private AutoscalingCapacity requiredCapacity;
        @Nullable
        private String reasonSummary;
        @Nullable
        private JsonData reasonDetails;

        public Builder requiredCapacity(AutoscalingCapacity value) {
            this.requiredCapacity = value;
            return this;
        }

        public Builder requiredCapacity(Function<AutoscalingCapacity.Builder, ObjectBuilder<AutoscalingCapacity>> fn) {
            return this.requiredCapacity(fn.apply(new AutoscalingCapacity.Builder()).build());
        }

        public Builder reasonSummary(@Nullable String value) {
            this.reasonSummary = value;
            return this;
        }

        public Builder reasonDetails(@Nullable JsonData value) {
            this.reasonDetails = value;
            return this;
        }

        @Override
        public AutoscalingDecider build() {
            return new AutoscalingDecider(this);
        }
    }
}

