/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.async_search;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._core.search.FieldCollapse;
import co.elastic.clients.elasticsearch._core.search.Highlight;
import co.elastic.clients.elasticsearch._core.search.PointInTimeReference;
import co.elastic.clients.elasticsearch._core.search.Rescore;
import co.elastic.clients.elasticsearch._core.search.Suggest;
import co.elastic.clients.elasticsearch._types.DefaultOperator;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.ScriptField;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch._types.SuggestMode;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.async_search.SubmitResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SubmitRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final List<String> index;
    @Nullable
    private final Long batchedReduceSize;
    @Nullable
    private final String waitForCompletionTimeout;
    @Nullable
    private final Boolean keepOnCompletion;
    @Nullable
    private final Boolean typedKeys;
    @Nullable
    private final Map<String, Aggregation> aggs;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final Boolean allowPartialSearchResults;
    @Nullable
    private final String analyzer;
    @Nullable
    private final Boolean analyzeWildcard;
    @Nullable
    private final FieldCollapse collapse;
    @Nullable
    private final DefaultOperator defaultOperator;
    @Nullable
    private final String df;
    @Nullable
    private final List<String> docvalueFields;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    @Nullable
    private final Boolean explain;
    @Nullable
    private final Integer from;
    @Nullable
    private final Highlight highlight;
    @Nullable
    private final Boolean ignoreThrottled;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final List<Map<String, Double>> indicesBoost;
    @Nullable
    private final String keepAlive;
    @Nullable
    private final Boolean lenient;
    @Nullable
    private final Long maxConcurrentShardRequests;
    @Nullable
    private final Double minScore;
    @Nullable
    private final Query postFilter;
    @Nullable
    private final String preference;
    @Nullable
    private final Boolean profile;
    @Nullable
    private final PointInTimeReference pit;
    @Nullable
    private final Query query;
    @Nullable
    private final Boolean requestCache;
    @Nullable
    private final List<Rescore> rescore;
    @Nullable
    private final String routing;
    @Nullable
    private final Map<String, ScriptField> scriptFields;
    @Nullable
    private final List<String> searchAfter;
    @Nullable
    private final SearchType searchType;
    @Nullable
    private final Boolean sequenceNumberPrimaryTerm;
    @Nullable
    private final Integer size;
    @Nullable
    private final List<JsonValue> sort;
    @Nullable
    private final JsonValue source;
    @Nullable
    private final List<String> stats;
    @Nullable
    private final List<String> storedFields;
    @Nullable
    private final Map<String, Suggest> suggest;
    @Nullable
    private final String suggestField;
    @Nullable
    private final SuggestMode suggestMode;
    @Nullable
    private final Long suggestSize;
    @Nullable
    private final String suggestText;
    @Nullable
    private final Long terminateAfter;
    @Nullable
    private final String timeout;
    @Nullable
    private final Boolean trackScores;
    @Nullable
    private final Boolean trackTotalHits;
    @Nullable
    private final Boolean version;
    @Nullable
    private final List<JsonValue> fields;
    @Nullable
    private final Map<String, RuntimeField> runtimeMappings;
    public static final JsonpDeserializer<SubmitRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SubmitRequest::setupSubmitRequestDeserializer, Builder::build);
    private static final SimpleEndpoint<SubmitRequest, Void> ENDPOINT = new SimpleEndpoint(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_async_search");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_async_search");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.batchedReduceSize != null) {
            params.put("batched_reduce_size", String.valueOf(request.batchedReduceSize));
        }
        if (request.waitForCompletionTimeout != null) {
            params.put("wait_for_completion_timeout", request.waitForCompletionTimeout);
        }
        if (request.keepOnCompletion != null) {
            params.put("keep_on_completion", String.valueOf(request.keepOnCompletion));
        }
        if (request.typedKeys != null) {
            params.put("typed_keys", String.valueOf(request.typedKeys));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, null);

    public SubmitRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiable(builder.index);
        this.batchedReduceSize = builder.batchedReduceSize;
        this.waitForCompletionTimeout = builder.waitForCompletionTimeout;
        this.keepOnCompletion = builder.keepOnCompletion;
        this.typedKeys = builder.typedKeys;
        this.aggs = ModelTypeHelper.unmodifiable(builder.aggs);
        this.allowNoIndices = builder.allowNoIndices;
        this.allowPartialSearchResults = builder.allowPartialSearchResults;
        this.analyzer = builder.analyzer;
        this.analyzeWildcard = builder.analyzeWildcard;
        this.collapse = builder.collapse;
        this.defaultOperator = builder.defaultOperator;
        this.df = builder.df;
        this.docvalueFields = ModelTypeHelper.unmodifiable(builder.docvalueFields);
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
        this.explain = builder.explain;
        this.from = builder.from;
        this.highlight = builder.highlight;
        this.ignoreThrottled = builder.ignoreThrottled;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.indicesBoost = ModelTypeHelper.unmodifiable(builder.indicesBoost);
        this.keepAlive = builder.keepAlive;
        this.lenient = builder.lenient;
        this.maxConcurrentShardRequests = builder.maxConcurrentShardRequests;
        this.minScore = builder.minScore;
        this.postFilter = builder.postFilter;
        this.preference = builder.preference;
        this.profile = builder.profile;
        this.pit = builder.pit;
        this.query = builder.query;
        this.requestCache = builder.requestCache;
        this.rescore = ModelTypeHelper.unmodifiable(builder.rescore);
        this.routing = builder.routing;
        this.scriptFields = ModelTypeHelper.unmodifiable(builder.scriptFields);
        this.searchAfter = ModelTypeHelper.unmodifiable(builder.searchAfter);
        this.searchType = builder.searchType;
        this.sequenceNumberPrimaryTerm = builder.sequenceNumberPrimaryTerm;
        this.size = builder.size;
        this.sort = ModelTypeHelper.unmodifiable(builder.sort);
        this.source = builder.source;
        this.stats = ModelTypeHelper.unmodifiable(builder.stats);
        this.storedFields = ModelTypeHelper.unmodifiable(builder.storedFields);
        this.suggest = ModelTypeHelper.unmodifiable(builder.suggest);
        this.suggestField = builder.suggestField;
        this.suggestMode = builder.suggestMode;
        this.suggestSize = builder.suggestSize;
        this.suggestText = builder.suggestText;
        this.terminateAfter = builder.terminateAfter;
        this.timeout = builder.timeout;
        this.trackScores = builder.trackScores;
        this.trackTotalHits = builder.trackTotalHits;
        this.version = builder.version;
        this.fields = ModelTypeHelper.unmodifiable(builder.fields);
        this.runtimeMappings = ModelTypeHelper.unmodifiable(builder.runtimeMappings);
    }

    public SubmitRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> index() {
        return this.index;
    }

    @Nullable
    public Long batchedReduceSize() {
        return this.batchedReduceSize;
    }

    @Nullable
    public String waitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    @Nullable
    public Boolean keepOnCompletion() {
        return this.keepOnCompletion;
    }

    @Nullable
    public Boolean typedKeys() {
        return this.typedKeys;
    }

    @Nullable
    public Map<String, Aggregation> aggs() {
        return this.aggs;
    }

    @Nullable
    public Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public Boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    @Nullable
    public String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public Boolean analyzeWildcard() {
        return this.analyzeWildcard;
    }

    @Nullable
    public FieldCollapse collapse() {
        return this.collapse;
    }

    @Nullable
    public DefaultOperator defaultOperator() {
        return this.defaultOperator;
    }

    @Nullable
    public String df() {
        return this.df;
    }

    @Nullable
    public List<String> docvalueFields() {
        return this.docvalueFields;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public Boolean explain() {
        return this.explain;
    }

    @Nullable
    public Integer from() {
        return this.from;
    }

    @Nullable
    public Highlight highlight() {
        return this.highlight;
    }

    @Nullable
    public Boolean ignoreThrottled() {
        return this.ignoreThrottled;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public List<Map<String, Double>> indicesBoost() {
        return this.indicesBoost;
    }

    @Nullable
    public String keepAlive() {
        return this.keepAlive;
    }

    @Nullable
    public Boolean lenient() {
        return this.lenient;
    }

    @Nullable
    public Long maxConcurrentShardRequests() {
        return this.maxConcurrentShardRequests;
    }

    @Nullable
    public Double minScore() {
        return this.minScore;
    }

    @Nullable
    public Query postFilter() {
        return this.postFilter;
    }

    @Nullable
    public String preference() {
        return this.preference;
    }

    @Nullable
    public Boolean profile() {
        return this.profile;
    }

    @Nullable
    public PointInTimeReference pit() {
        return this.pit;
    }

    @Nullable
    public Query query() {
        return this.query;
    }

    @Nullable
    public Boolean requestCache() {
        return this.requestCache;
    }

    @Nullable
    public List<Rescore> rescore() {
        return this.rescore;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public Map<String, ScriptField> scriptFields() {
        return this.scriptFields;
    }

    @Nullable
    public List<String> searchAfter() {
        return this.searchAfter;
    }

    @Nullable
    public SearchType searchType() {
        return this.searchType;
    }

    @Nullable
    public Boolean sequenceNumberPrimaryTerm() {
        return this.sequenceNumberPrimaryTerm;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public List<JsonValue> sort() {
        return this.sort;
    }

    @Nullable
    public JsonValue source() {
        return this.source;
    }

    @Nullable
    public List<String> stats() {
        return this.stats;
    }

    @Nullable
    public List<String> storedFields() {
        return this.storedFields;
    }

    @Nullable
    public Map<String, Suggest> suggest() {
        return this.suggest;
    }

    @Nullable
    public String suggestField() {
        return this.suggestField;
    }

    @Nullable
    public SuggestMode suggestMode() {
        return this.suggestMode;
    }

    @Nullable
    public Long suggestSize() {
        return this.suggestSize;
    }

    @Nullable
    public String suggestText() {
        return this.suggestText;
    }

    @Nullable
    public Long terminateAfter() {
        return this.terminateAfter;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public Boolean trackScores() {
        return this.trackScores;
    }

    @Nullable
    public Boolean trackTotalHits() {
        return this.trackTotalHits;
    }

    @Nullable
    public Boolean version() {
        return this.version;
    }

    @Nullable
    public List<JsonValue> fields() {
        return this.fields;
    }

    @Nullable
    public Map<String, RuntimeField> runtimeMappings() {
        return this.runtimeMappings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.aggs != null) {
            generator.writeKey("aggs");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> entry : this.aggs.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.allowNoIndices != null) {
            generator.writeKey("allow_no_indices");
            generator.write(this.allowNoIndices.booleanValue());
        }
        if (this.allowPartialSearchResults != null) {
            generator.writeKey("allow_partial_search_results");
            generator.write(this.allowPartialSearchResults.booleanValue());
        }
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.analyzeWildcard != null) {
            generator.writeKey("analyze_wildcard");
            generator.write(this.analyzeWildcard.booleanValue());
        }
        if (this.collapse != null) {
            generator.writeKey("collapse");
            this.collapse.serialize(generator, mapper);
        }
        if (this.defaultOperator != null) {
            generator.writeKey("default_operator");
            this.defaultOperator.serialize(generator, mapper);
        }
        if (this.df != null) {
            generator.writeKey("df");
            generator.write(this.df);
        }
        if (this.docvalueFields != null) {
            generator.writeKey("docvalue_fields");
            generator.writeStartArray();
            for (String string : this.docvalueFields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.expandWildcards != null) {
            generator.writeKey("expand_wildcards");
            generator.writeStartArray();
            for (ExpandWildcardOptions expandWildcardOptions : this.expandWildcards) {
                expandWildcardOptions.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.explain != null) {
            generator.writeKey("explain");
            generator.write(this.explain.booleanValue());
        }
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from.intValue());
        }
        if (this.highlight != null) {
            generator.writeKey("highlight");
            this.highlight.serialize(generator, mapper);
        }
        if (this.ignoreThrottled != null) {
            generator.writeKey("ignore_throttled");
            generator.write(this.ignoreThrottled.booleanValue());
        }
        if (this.ignoreUnavailable != null) {
            generator.writeKey("ignore_unavailable");
            generator.write(this.ignoreUnavailable.booleanValue());
        }
        if (this.indicesBoost != null) {
            generator.writeKey("indices_boost");
            generator.writeStartArray();
            for (Map map : this.indicesBoost) {
                generator.writeStartObject();
                for (Map.Entry item1 : map.entrySet()) {
                    generator.writeKey((String)item1.getKey());
                    generator.write(((Double)item1.getValue()).doubleValue());
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.keepAlive != null) {
            generator.writeKey("keep_alive");
            generator.write(this.keepAlive);
        }
        if (this.lenient != null) {
            generator.writeKey("lenient");
            generator.write(this.lenient.booleanValue());
        }
        if (this.maxConcurrentShardRequests != null) {
            generator.writeKey("max_concurrent_shard_requests");
            generator.write(this.maxConcurrentShardRequests.longValue());
        }
        if (this.minScore != null) {
            generator.writeKey("min_score");
            generator.write(this.minScore.doubleValue());
        }
        if (this.postFilter != null) {
            generator.writeKey("post_filter");
            this.postFilter.serialize(generator, mapper);
        }
        if (this.preference != null) {
            generator.writeKey("preference");
            generator.write(this.preference);
        }
        if (this.profile != null) {
            generator.writeKey("profile");
            generator.write(this.profile.booleanValue());
        }
        if (this.pit != null) {
            generator.writeKey("pit");
            this.pit.serialize(generator, mapper);
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.requestCache != null) {
            generator.writeKey("request_cache");
            generator.write(this.requestCache.booleanValue());
        }
        if (this.rescore != null) {
            generator.writeKey("rescore");
            generator.writeStartArray();
            for (Rescore rescore : this.rescore) {
                rescore.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (this.scriptFields != null) {
            generator.writeKey("script_fields");
            generator.writeStartObject();
            for (Map.Entry entry : this.scriptFields.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ScriptField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.searchAfter != null) {
            generator.writeKey("search_after");
            generator.writeStartArray();
            for (String string : this.searchAfter) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.searchType != null) {
            generator.writeKey("search_type");
            this.searchType.serialize(generator, mapper);
        }
        if (this.sequenceNumberPrimaryTerm != null) {
            generator.writeKey("sequence_number_primary_term");
            generator.write(this.sequenceNumberPrimaryTerm.booleanValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.sort != null) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (JsonValue jsonValue : this.sort) {
                generator.write(jsonValue);
            }
            generator.writeEnd();
        }
        if (this.source != null) {
            generator.writeKey("_source");
            generator.write(this.source);
        }
        if (this.stats != null) {
            generator.writeKey("stats");
            generator.writeStartArray();
            for (String string : this.stats) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.storedFields != null) {
            generator.writeKey("stored_fields");
            generator.writeStartArray();
            for (String string : this.storedFields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.suggest != null) {
            generator.writeKey("suggest");
            generator.writeStartObject();
            for (Map.Entry entry : this.suggest.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((Suggest)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.suggestField != null) {
            generator.writeKey("suggest_field");
            generator.write(this.suggestField);
        }
        if (this.suggestMode != null) {
            generator.writeKey("suggest_mode");
            this.suggestMode.serialize(generator, mapper);
        }
        if (this.suggestSize != null) {
            generator.writeKey("suggest_size");
            generator.write(this.suggestSize.longValue());
        }
        if (this.suggestText != null) {
            generator.writeKey("suggest_text");
            generator.write(this.suggestText);
        }
        if (this.terminateAfter != null) {
            generator.writeKey("terminate_after");
            generator.write(this.terminateAfter.longValue());
        }
        if (this.timeout != null) {
            generator.writeKey("timeout");
            generator.write(this.timeout);
        }
        if (this.trackScores != null) {
            generator.writeKey("track_scores");
            generator.write(this.trackScores.booleanValue());
        }
        if (this.trackTotalHits != null) {
            generator.writeKey("track_total_hits");
            generator.write(this.trackTotalHits.booleanValue());
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.booleanValue());
        }
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (JsonValue jsonValue : this.fields) {
                generator.write(jsonValue);
            }
            generator.writeEnd();
        }
        if (this.runtimeMappings != null) {
            generator.writeKey("runtime_mappings");
            generator.writeStartObject();
            for (Map.Entry entry : this.runtimeMappings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((RuntimeField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupSubmitRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aggs, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggs", new String[0]);
        op.add(Builder::allowNoIndices, JsonpDeserializer.booleanDeserializer(), "allow_no_indices", new String[0]);
        op.add(Builder::allowPartialSearchResults, JsonpDeserializer.booleanDeserializer(), "allow_partial_search_results", new String[0]);
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer", new String[0]);
        op.add(Builder::analyzeWildcard, JsonpDeserializer.booleanDeserializer(), "analyze_wildcard", new String[0]);
        op.add(Builder::collapse, FieldCollapse._DESERIALIZER, "collapse", new String[0]);
        op.add(Builder::defaultOperator, DefaultOperator._DESERIALIZER, "default_operator", new String[0]);
        op.add(Builder::df, JsonpDeserializer.stringDeserializer(), "df", new String[0]);
        op.add(Builder::docvalueFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "docvalue_fields", new String[0]);
        op.add(Builder::expandWildcards, JsonpDeserializer.arrayDeserializer(ExpandWildcardOptions._DESERIALIZER), "expand_wildcards", new String[0]);
        op.add(Builder::explain, JsonpDeserializer.booleanDeserializer(), "explain", new String[0]);
        op.add(Builder::from, JsonpDeserializer.integerDeserializer(), "from", new String[0]);
        op.add(Builder::highlight, Highlight._DESERIALIZER, "highlight", new String[0]);
        op.add(Builder::ignoreThrottled, JsonpDeserializer.booleanDeserializer(), "ignore_throttled", new String[0]);
        op.add(Builder::ignoreUnavailable, JsonpDeserializer.booleanDeserializer(), "ignore_unavailable", new String[0]);
        op.add(Builder::indicesBoost, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer())), "indices_boost", new String[0]);
        op.add(Builder::keepAlive, JsonpDeserializer.stringDeserializer(), "keep_alive", new String[0]);
        op.add(Builder::lenient, JsonpDeserializer.booleanDeserializer(), "lenient", new String[0]);
        op.add(Builder::maxConcurrentShardRequests, JsonpDeserializer.longDeserializer(), "max_concurrent_shard_requests", new String[0]);
        op.add(Builder::minScore, JsonpDeserializer.doubleDeserializer(), "min_score", new String[0]);
        op.add(Builder::postFilter, Query._DESERIALIZER, "post_filter", new String[0]);
        op.add(Builder::preference, JsonpDeserializer.stringDeserializer(), "preference", new String[0]);
        op.add(Builder::profile, JsonpDeserializer.booleanDeserializer(), "profile", new String[0]);
        op.add(Builder::pit, PointInTimeReference._DESERIALIZER, "pit", new String[0]);
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
        op.add(Builder::requestCache, JsonpDeserializer.booleanDeserializer(), "request_cache", new String[0]);
        op.add(Builder::rescore, JsonpDeserializer.arrayDeserializer(Rescore._DESERIALIZER), "rescore", new String[0]);
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "routing", new String[0]);
        op.add(Builder::scriptFields, JsonpDeserializer.stringMapDeserializer(ScriptField._DESERIALIZER), "script_fields", new String[0]);
        op.add(Builder::searchAfter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "search_after", new String[0]);
        op.add(Builder::searchType, SearchType._DESERIALIZER, "search_type", new String[0]);
        op.add(Builder::sequenceNumberPrimaryTerm, JsonpDeserializer.booleanDeserializer(), "sequence_number_primary_term", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "sort", new String[0]);
        op.add(Builder::source, JsonpDeserializer.jsonValueDeserializer(), "_source", new String[0]);
        op.add(Builder::stats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stats", new String[0]);
        op.add(Builder::storedFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stored_fields", new String[0]);
        op.add(Builder::suggest, JsonpDeserializer.stringMapDeserializer(Suggest._DESERIALIZER), "suggest", new String[0]);
        op.add(Builder::suggestField, JsonpDeserializer.stringDeserializer(), "suggest_field", new String[0]);
        op.add(Builder::suggestMode, SuggestMode._DESERIALIZER, "suggest_mode", new String[0]);
        op.add(Builder::suggestSize, JsonpDeserializer.longDeserializer(), "suggest_size", new String[0]);
        op.add(Builder::suggestText, JsonpDeserializer.stringDeserializer(), "suggest_text", new String[0]);
        op.add(Builder::terminateAfter, JsonpDeserializer.longDeserializer(), "terminate_after", new String[0]);
        op.add(Builder::timeout, JsonpDeserializer.stringDeserializer(), "timeout", new String[0]);
        op.add(Builder::trackScores, JsonpDeserializer.booleanDeserializer(), "track_scores", new String[0]);
        op.add(Builder::trackTotalHits, JsonpDeserializer.booleanDeserializer(), "track_total_hits", new String[0]);
        op.add(Builder::version, JsonpDeserializer.booleanDeserializer(), "version", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "fields", new String[0]);
        op.add(Builder::runtimeMappings, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime_mappings", new String[0]);
    }

    public static <TDocument> Endpoint<SubmitRequest, SubmitResponse<TDocument>, ElasticsearchError> createSubmitEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ENDPOINT.withResponseDeserializer(SubmitResponse.createSubmitResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    implements ObjectBuilder<SubmitRequest> {
        @Nullable
        private List<String> index;
        @Nullable
        private Long batchedReduceSize;
        @Nullable
        private String waitForCompletionTimeout;
        @Nullable
        private Boolean keepOnCompletion;
        @Nullable
        private Boolean typedKeys;
        @Nullable
        private Map<String, Aggregation> aggs;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private Boolean allowPartialSearchResults;
        @Nullable
        private String analyzer;
        @Nullable
        private Boolean analyzeWildcard;
        @Nullable
        private FieldCollapse collapse;
        @Nullable
        private DefaultOperator defaultOperator;
        @Nullable
        private String df;
        @Nullable
        private List<String> docvalueFields;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;
        @Nullable
        private Boolean explain;
        @Nullable
        private Integer from;
        @Nullable
        private Highlight highlight;
        @Nullable
        private Boolean ignoreThrottled;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private List<Map<String, Double>> indicesBoost;
        @Nullable
        private String keepAlive;
        @Nullable
        private Boolean lenient;
        @Nullable
        private Long maxConcurrentShardRequests;
        @Nullable
        private Double minScore;
        @Nullable
        private Query postFilter;
        @Nullable
        private String preference;
        @Nullable
        private Boolean profile;
        @Nullable
        private PointInTimeReference pit;
        @Nullable
        private Query query;
        @Nullable
        private Boolean requestCache;
        @Nullable
        private List<Rescore> rescore;
        @Nullable
        private String routing;
        @Nullable
        private Map<String, ScriptField> scriptFields;
        @Nullable
        private List<String> searchAfter;
        @Nullable
        private SearchType searchType;
        @Nullable
        private Boolean sequenceNumberPrimaryTerm;
        @Nullable
        private Integer size;
        @Nullable
        private List<JsonValue> sort;
        @Nullable
        private JsonValue source;
        @Nullable
        private List<String> stats;
        @Nullable
        private List<String> storedFields;
        @Nullable
        private Map<String, Suggest> suggest;
        @Nullable
        private String suggestField;
        @Nullable
        private SuggestMode suggestMode;
        @Nullable
        private Long suggestSize;
        @Nullable
        private String suggestText;
        @Nullable
        private Long terminateAfter;
        @Nullable
        private String timeout;
        @Nullable
        private Boolean trackScores;
        @Nullable
        private Boolean trackTotalHits;
        @Nullable
        private Boolean version;
        @Nullable
        private List<JsonValue> fields;
        @Nullable
        private Map<String, RuntimeField> runtimeMappings;

        public Builder index(@Nullable List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder batchedReduceSize(@Nullable Long value) {
            this.batchedReduceSize = value;
            return this;
        }

        public Builder waitForCompletionTimeout(@Nullable String value) {
            this.waitForCompletionTimeout = value;
            return this;
        }

        public Builder keepOnCompletion(@Nullable Boolean value) {
            this.keepOnCompletion = value;
            return this;
        }

        public Builder typedKeys(@Nullable Boolean value) {
            this.typedKeys = value;
            return this;
        }

        public Builder aggs(@Nullable Map<String, Aggregation> value) {
            this.aggs = value;
            return this;
        }

        public Builder putAggs(String key, Aggregation value) {
            if (this.aggs == null) {
                this.aggs = new HashMap<String, Aggregation>();
            }
            this.aggs.put(key, value);
            return this;
        }

        public Builder aggs(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggs(Collections.singletonMap(key, fn.apply(new Aggregation.Builder()).build()));
        }

        public Builder putAggs(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.putAggs(key, fn.apply(new Aggregation.Builder()).build());
        }

        public Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public Builder allowPartialSearchResults(@Nullable Boolean value) {
            this.allowPartialSearchResults = value;
            return this;
        }

        public Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public Builder analyzeWildcard(@Nullable Boolean value) {
            this.analyzeWildcard = value;
            return this;
        }

        public Builder collapse(@Nullable FieldCollapse value) {
            this.collapse = value;
            return this;
        }

        public Builder collapse(Function<FieldCollapse.Builder, ObjectBuilder<FieldCollapse>> fn) {
            return this.collapse(fn.apply(new FieldCollapse.Builder()).build());
        }

        public Builder defaultOperator(@Nullable DefaultOperator value) {
            this.defaultOperator = value;
            return this;
        }

        public Builder df(@Nullable String value) {
            this.df = value;
            return this;
        }

        public Builder docvalueFields(@Nullable List<String> value) {
            this.docvalueFields = value;
            return this;
        }

        public Builder docvalueFields(String ... value) {
            this.docvalueFields = Arrays.asList(value);
            return this;
        }

        public Builder addDocvalueFields(String value) {
            if (this.docvalueFields == null) {
                this.docvalueFields = new ArrayList<String>();
            }
            this.docvalueFields.add(value);
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        public Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        public Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public Builder highlight(@Nullable Highlight value) {
            this.highlight = value;
            return this;
        }

        public Builder highlight(Function<Highlight.Builder, ObjectBuilder<Highlight>> fn) {
            return this.highlight(fn.apply(new Highlight.Builder()).build());
        }

        public Builder ignoreThrottled(@Nullable Boolean value) {
            this.ignoreThrottled = value;
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder indicesBoost(@Nullable List<Map<String, Double>> value) {
            this.indicesBoost = value;
            return this;
        }

        public Builder indicesBoost(Map<String, Double> ... value) {
            this.indicesBoost = Arrays.asList(value);
            return this;
        }

        public Builder addIndicesBoost(Map<String, Double> value) {
            if (this.indicesBoost == null) {
                this.indicesBoost = new ArrayList<Map<String, Double>>();
            }
            this.indicesBoost.add(value);
            return this;
        }

        public Builder keepAlive(@Nullable String value) {
            this.keepAlive = value;
            return this;
        }

        public Builder lenient(@Nullable Boolean value) {
            this.lenient = value;
            return this;
        }

        public Builder maxConcurrentShardRequests(@Nullable Long value) {
            this.maxConcurrentShardRequests = value;
            return this;
        }

        public Builder minScore(@Nullable Double value) {
            this.minScore = value;
            return this;
        }

        public Builder postFilter(@Nullable Query value) {
            this.postFilter = value;
            return this;
        }

        public Builder postFilter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.postFilter(fn.apply(new Query.Builder()).build());
        }

        public Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        public Builder profile(@Nullable Boolean value) {
            this.profile = value;
            return this;
        }

        public Builder pit(@Nullable PointInTimeReference value) {
            this.pit = value;
            return this;
        }

        public Builder pit(Function<PointInTimeReference.Builder, ObjectBuilder<PointInTimeReference>> fn) {
            return this.pit(fn.apply(new PointInTimeReference.Builder()).build());
        }

        public Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public Builder requestCache(@Nullable Boolean value) {
            this.requestCache = value;
            return this;
        }

        public Builder rescore(@Nullable List<Rescore> value) {
            this.rescore = value;
            return this;
        }

        public Builder rescore(Rescore ... value) {
            this.rescore = Arrays.asList(value);
            return this;
        }

        public Builder addRescore(Rescore value) {
            if (this.rescore == null) {
                this.rescore = new ArrayList<Rescore>();
            }
            this.rescore.add(value);
            return this;
        }

        public Builder rescore(Function<Rescore.Builder, ObjectBuilder<Rescore>> fn) {
            return this.rescore(fn.apply(new Rescore.Builder()).build());
        }

        public Builder addRescore(Function<Rescore.Builder, ObjectBuilder<Rescore>> fn) {
            return this.addRescore(fn.apply(new Rescore.Builder()).build());
        }

        public Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder scriptFields(@Nullable Map<String, ScriptField> value) {
            this.scriptFields = value;
            return this;
        }

        public Builder putScriptFields(String key, ScriptField value) {
            if (this.scriptFields == null) {
                this.scriptFields = new HashMap<String, ScriptField>();
            }
            this.scriptFields.put(key, value);
            return this;
        }

        public Builder scriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.scriptFields(Collections.singletonMap(key, fn.apply(new ScriptField.Builder()).build()));
        }

        public Builder putScriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.putScriptFields(key, fn.apply(new ScriptField.Builder()).build());
        }

        public Builder searchAfter(@Nullable List<String> value) {
            this.searchAfter = value;
            return this;
        }

        public Builder searchAfter(String ... value) {
            this.searchAfter = Arrays.asList(value);
            return this;
        }

        public Builder addSearchAfter(String value) {
            if (this.searchAfter == null) {
                this.searchAfter = new ArrayList<String>();
            }
            this.searchAfter.add(value);
            return this;
        }

        public Builder searchType(@Nullable SearchType value) {
            this.searchType = value;
            return this;
        }

        public Builder sequenceNumberPrimaryTerm(@Nullable Boolean value) {
            this.sequenceNumberPrimaryTerm = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder sort(@Nullable List<JsonValue> value) {
            this.sort = value;
            return this;
        }

        public Builder sort(JsonValue ... value) {
            this.sort = Arrays.asList(value);
            return this;
        }

        public Builder addSort(JsonValue value) {
            if (this.sort == null) {
                this.sort = new ArrayList<JsonValue>();
            }
            this.sort.add(value);
            return this;
        }

        public Builder source(@Nullable JsonValue value) {
            this.source = value;
            return this;
        }

        public Builder stats(@Nullable List<String> value) {
            this.stats = value;
            return this;
        }

        public Builder stats(String ... value) {
            this.stats = Arrays.asList(value);
            return this;
        }

        public Builder addStats(String value) {
            if (this.stats == null) {
                this.stats = new ArrayList<String>();
            }
            this.stats.add(value);
            return this;
        }

        public Builder storedFields(@Nullable List<String> value) {
            this.storedFields = value;
            return this;
        }

        public Builder storedFields(String ... value) {
            this.storedFields = Arrays.asList(value);
            return this;
        }

        public Builder addStoredFields(String value) {
            if (this.storedFields == null) {
                this.storedFields = new ArrayList<String>();
            }
            this.storedFields.add(value);
            return this;
        }

        public Builder suggest(@Nullable Map<String, Suggest> value) {
            this.suggest = value;
            return this;
        }

        public Builder putSuggest(String key, Suggest value) {
            if (this.suggest == null) {
                this.suggest = new HashMap<String, Suggest>();
            }
            this.suggest.put(key, value);
            return this;
        }

        public Builder suggest(String key, Function<Suggest.Builder, ObjectBuilder<Suggest>> fn) {
            return this.suggest(Collections.singletonMap(key, fn.apply(new Suggest.Builder()).build()));
        }

        public Builder putSuggest(String key, Function<Suggest.Builder, ObjectBuilder<Suggest>> fn) {
            return this.putSuggest(key, fn.apply(new Suggest.Builder()).build());
        }

        public Builder suggestField(@Nullable String value) {
            this.suggestField = value;
            return this;
        }

        public Builder suggestMode(@Nullable SuggestMode value) {
            this.suggestMode = value;
            return this;
        }

        public Builder suggestSize(@Nullable Long value) {
            this.suggestSize = value;
            return this;
        }

        public Builder suggestText(@Nullable String value) {
            this.suggestText = value;
            return this;
        }

        public Builder terminateAfter(@Nullable Long value) {
            this.terminateAfter = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder trackScores(@Nullable Boolean value) {
            this.trackScores = value;
            return this;
        }

        public Builder trackTotalHits(@Nullable Boolean value) {
            this.trackTotalHits = value;
            return this;
        }

        public Builder version(@Nullable Boolean value) {
            this.version = value;
            return this;
        }

        public Builder fields(@Nullable List<JsonValue> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(JsonValue ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(JsonValue value) {
            if (this.fields == null) {
                this.fields = new ArrayList<JsonValue>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder runtimeMappings(@Nullable Map<String, RuntimeField> value) {
            this.runtimeMappings = value;
            return this;
        }

        public Builder putRuntimeMappings(String key, RuntimeField value) {
            if (this.runtimeMappings == null) {
                this.runtimeMappings = new HashMap<String, RuntimeField>();
            }
            this.runtimeMappings.put(key, value);
            return this;
        }

        public Builder runtimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtimeMappings(Collections.singletonMap(key, fn.apply(new RuntimeField.Builder()).build()));
        }

        public Builder putRuntimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.putRuntimeMappings(key, fn.apply(new RuntimeField.Builder()).build());
        }

        @Override
        public SubmitRequest build() {
            return new SubmitRequest(this);
        }
    }
}

