/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class WildcardQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    @Nullable
    private final Boolean caseInsensitive;
    @Nullable
    private final String rewrite;
    private final String value;
    public static final JsonpDeserializer<WildcardQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WildcardQuery::setupWildcardQueryDeserializer, Builder::build);

    public WildcardQuery(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.caseInsensitive = builder.caseInsensitive;
        this.rewrite = builder.rewrite;
        this.value = Objects.requireNonNull(builder.value, "value");
    }

    public WildcardQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "wildcard";
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public Boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    @Nullable
    public String rewrite() {
        return this.rewrite;
    }

    public String value() {
        return this.value;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.caseInsensitive != null) {
            generator.writeKey("case_insensitive");
            generator.write(this.caseInsensitive.booleanValue());
        }
        if (this.rewrite != null) {
            generator.writeKey("rewrite");
            generator.write(this.rewrite);
        }
        generator.writeKey("value");
        generator.write(this.value);
        generator.writeEnd();
    }

    protected static void setupWildcardQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::caseInsensitive, JsonpDeserializer.booleanDeserializer(), "case_insensitive", new String[0]);
        op.add(Builder::rewrite, JsonpDeserializer.stringDeserializer(), "rewrite", new String[0]);
        op.add(Builder::value, JsonpDeserializer.stringDeserializer(), "value", new String[0]);
        op.setKey(Builder::field);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<WildcardQuery> {
        private String field;
        @Nullable
        private Boolean caseInsensitive;
        @Nullable
        private String rewrite;
        private String value;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder caseInsensitive(@Nullable Boolean value) {
            this.caseInsensitive = value;
            return this;
        }

        public Builder rewrite(@Nullable String value) {
            this.rewrite = value;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WildcardQuery build() {
            return new WildcardQuery(this);
        }
    }
}

