/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TermQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    private final String value;
    @Nullable
    private final Boolean caseInsensitive;
    public static final JsonpDeserializer<TermQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermQuery::setupTermQueryDeserializer, Builder::build);

    public TermQuery(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.value = Objects.requireNonNull(builder.value, "value");
        this.caseInsensitive = builder.caseInsensitive;
    }

    public TermQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "term";
    }

    public String field() {
        return this.field;
    }

    public String value() {
        return this.value;
    }

    @Nullable
    public Boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        generator.writeKey("value");
        generator.write(this.value);
        if (this.caseInsensitive != null) {
            generator.writeKey("case_insensitive");
            generator.write(this.caseInsensitive.booleanValue());
        }
        generator.writeEnd();
    }

    protected static void setupTermQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::value, JsonpDeserializer.stringDeserializer(), "value", new String[0]);
        op.add(Builder::caseInsensitive, JsonpDeserializer.booleanDeserializer(), "case_insensitive", new String[0]);
        op.setKey(Builder::field);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TermQuery> {
        private String field;
        private String value;
        @Nullable
        private Boolean caseInsensitive;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder caseInsensitive(@Nullable Boolean value) {
            this.caseInsensitive = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TermQuery build() {
            return new TermQuery(this);
        }
    }
}

