/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class SpanFirstQuery
extends QueryBase
implements SpanQueryVariant,
QueryVariant {
    private final int end;
    private final SpanQuery match;
    public static final JsonpDeserializer<SpanFirstQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SpanFirstQuery::setupSpanFirstQueryDeserializer, Builder::build);

    public SpanFirstQuery(Builder builder) {
        super(builder);
        this.end = Objects.requireNonNull(builder.end, "end");
        this.match = Objects.requireNonNull(builder.match, "match");
    }

    public SpanFirstQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "span_first";
    }

    public int end() {
        return this.end;
    }

    public SpanQuery match() {
        return this.match;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("end");
        generator.write(this.end);
        generator.writeKey("match");
        this.match.serialize(generator, mapper);
    }

    protected static void setupSpanFirstQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::end, JsonpDeserializer.integerDeserializer(), "end", new String[0]);
        op.add(Builder::match, SpanQuery._DESERIALIZER, "match", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SpanFirstQuery> {
        private Integer end;
        private SpanQuery match;

        public Builder end(int value) {
            this.end = value;
            return this;
        }

        public Builder match(SpanQuery value) {
            this.match = value;
            return this;
        }

        public Builder match(Function<SpanQuery.Builder, ObjectBuilder<SpanQuery>> fn) {
            return this.match(fn.apply(new SpanQuery.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SpanFirstQuery build() {
            return new SpanFirstQuery(this);
        }
    }
}

