/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ScriptScoreQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final Float minScore;
    private final Query query;
    private final JsonValue script;
    public static final JsonpDeserializer<ScriptScoreQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptScoreQuery::setupScriptScoreQueryDeserializer, Builder::build);

    public ScriptScoreQuery(Builder builder) {
        super(builder);
        this.minScore = builder.minScore;
        this.query = Objects.requireNonNull(builder.query, "query");
        this.script = Objects.requireNonNull(builder.script, "script");
    }

    public ScriptScoreQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "script_score";
    }

    @Nullable
    public Float minScore() {
        return this.minScore;
    }

    public Query query() {
        return this.query;
    }

    public JsonValue script() {
        return this.script;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.minScore != null) {
            generator.writeKey("min_score");
            generator.write((double)this.minScore.floatValue());
        }
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        generator.writeKey("script");
        generator.write(this.script);
    }

    protected static void setupScriptScoreQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::minScore, JsonpDeserializer.floatDeserializer(), "min_score", new String[0]);
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), "script", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ScriptScoreQuery> {
        @Nullable
        private Float minScore;
        private Query query;
        private JsonValue script;

        public Builder minScore(@Nullable Float value) {
            this.minScore = value;
            return this;
        }

        public Builder query(Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public Builder script(JsonValue value) {
            this.script = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ScriptScoreQuery build() {
            return new ScriptScoreQuery(this);
        }
    }
}

