/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class QueryBase
implements JsonpSerializable {
    @Nullable
    private final Float boost;
    @Nullable
    private final String queryName;

    public QueryBase(AbstractBuilder<?> builder) {
        this.boost = ((AbstractBuilder)builder).boost;
        this.queryName = ((AbstractBuilder)builder).queryName;
    }

    @Nullable
    public Float boost() {
        return this.boost;
    }

    @Nullable
    public String queryName() {
        return this.queryName;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write((double)this.boost.floatValue());
        }
        if (this.queryName != null) {
            generator.writeKey("_name");
            generator.write(this.queryName);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupQueryBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::boost, JsonpDeserializer.floatDeserializer(), "boost", new String[0]);
        op.add(AbstractBuilder::queryName, JsonpDeserializer.stringDeserializer(), "_name", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        @Nullable
        private Float boost;
        @Nullable
        private String queryName;

        protected AbstractBuilder() {
        }

        public BuilderT boost(@Nullable Float value) {
            this.boost = value;
            return this.self();
        }

        public BuilderT queryName(@Nullable String value) {
            this.queryName = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

