/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsFilter;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsQueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IntervalsMatch
implements IntervalsQueryVariant,
IntervalsVariant,
JsonpSerializable {
    @Nullable
    private final String analyzer;
    @Nullable
    private final Integer maxGaps;
    @Nullable
    private final Boolean ordered;
    private final String query;
    @Nullable
    private final String useField;
    @Nullable
    private final IntervalsFilter filter;
    public static final JsonpDeserializer<IntervalsMatch> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IntervalsMatch::setupIntervalsMatchDeserializer, Builder::build);

    public IntervalsMatch(Builder builder) {
        this.analyzer = builder.analyzer;
        this.maxGaps = builder.maxGaps;
        this.ordered = builder.ordered;
        this.query = Objects.requireNonNull(builder.query, "query");
        this.useField = builder.useField;
        this.filter = builder.filter;
    }

    public IntervalsMatch(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "match";
    }

    @Nullable
    public String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public Integer maxGaps() {
        return this.maxGaps;
    }

    @Nullable
    public Boolean ordered() {
        return this.ordered;
    }

    public String query() {
        return this.query;
    }

    @Nullable
    public String useField() {
        return this.useField;
    }

    @Nullable
    public IntervalsFilter filter() {
        return this.filter;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.maxGaps != null) {
            generator.writeKey("max_gaps");
            generator.write(this.maxGaps.intValue());
        }
        if (this.ordered != null) {
            generator.writeKey("ordered");
            generator.write(this.ordered.booleanValue());
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (this.useField != null) {
            generator.writeKey("use_field");
            generator.write(this.useField);
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
    }

    protected static void setupIntervalsMatchDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer", new String[0]);
        op.add(Builder::maxGaps, JsonpDeserializer.integerDeserializer(), "max_gaps", new String[0]);
        op.add(Builder::ordered, JsonpDeserializer.booleanDeserializer(), "ordered", new String[0]);
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query", new String[0]);
        op.add(Builder::useField, JsonpDeserializer.stringDeserializer(), "use_field", new String[0]);
        op.add(Builder::filter, IntervalsFilter._DESERIALIZER, "filter", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IntervalsMatch> {
        @Nullable
        private String analyzer;
        @Nullable
        private Integer maxGaps;
        @Nullable
        private Boolean ordered;
        private String query;
        @Nullable
        private String useField;
        @Nullable
        private IntervalsFilter filter;

        public Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public Builder maxGaps(@Nullable Integer value) {
            this.maxGaps = value;
            return this;
        }

        public Builder ordered(@Nullable Boolean value) {
            this.ordered = value;
            return this;
        }

        public Builder query(String value) {
            this.query = value;
            return this;
        }

        public Builder useField(@Nullable String value) {
            this.useField = value;
            return this;
        }

        public Builder filter(@Nullable IntervalsFilter value) {
            this.filter = value;
            return this;
        }

        public Builder filter(Function<IntervalsFilter.Builder, ObjectBuilder<IntervalsFilter>> fn) {
            return this.filter(fn.apply(new IntervalsFilter.Builder()).build());
        }

        @Override
        public IntervalsMatch build() {
            return new IntervalsMatch(this);
        }
    }
}

