/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._core.search.InnerHits;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class HasChildQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final Boolean ignoreUnmapped;
    @Nullable
    private final InnerHits innerHits;
    @Nullable
    private final Integer maxChildren;
    @Nullable
    private final Integer minChildren;
    private final Query query;
    @Nullable
    private final ChildScoreMode scoreMode;
    private final String type;
    public static final JsonpDeserializer<HasChildQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HasChildQuery::setupHasChildQueryDeserializer, Builder::build);

    public HasChildQuery(Builder builder) {
        super(builder);
        this.ignoreUnmapped = builder.ignoreUnmapped;
        this.innerHits = builder.innerHits;
        this.maxChildren = builder.maxChildren;
        this.minChildren = builder.minChildren;
        this.query = Objects.requireNonNull(builder.query, "query");
        this.scoreMode = builder.scoreMode;
        this.type = Objects.requireNonNull(builder.type, "type");
    }

    public HasChildQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "has_child";
    }

    @Nullable
    public Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Nullable
    public InnerHits innerHits() {
        return this.innerHits;
    }

    @Nullable
    public Integer maxChildren() {
        return this.maxChildren;
    }

    @Nullable
    public Integer minChildren() {
        return this.minChildren;
    }

    public Query query() {
        return this.query;
    }

    @Nullable
    public ChildScoreMode scoreMode() {
        return this.scoreMode;
    }

    public String type() {
        return this.type;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
        if (this.innerHits != null) {
            generator.writeKey("inner_hits");
            this.innerHits.serialize(generator, mapper);
        }
        if (this.maxChildren != null) {
            generator.writeKey("max_children");
            generator.write(this.maxChildren.intValue());
        }
        if (this.minChildren != null) {
            generator.writeKey("min_children");
            generator.write(this.minChildren.intValue());
        }
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        if (this.scoreMode != null) {
            generator.writeKey("score_mode");
            this.scoreMode.serialize(generator, mapper);
        }
        generator.writeKey("type");
        generator.write(this.type);
    }

    protected static void setupHasChildQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped", new String[0]);
        op.add(Builder::innerHits, InnerHits._DESERIALIZER, "inner_hits", new String[0]);
        op.add(Builder::maxChildren, JsonpDeserializer.integerDeserializer(), "max_children", new String[0]);
        op.add(Builder::minChildren, JsonpDeserializer.integerDeserializer(), "min_children", new String[0]);
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
        op.add(Builder::scoreMode, ChildScoreMode._DESERIALIZER, "score_mode", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HasChildQuery> {
        @Nullable
        private Boolean ignoreUnmapped;
        @Nullable
        private InnerHits innerHits;
        @Nullable
        private Integer maxChildren;
        @Nullable
        private Integer minChildren;
        private Query query;
        @Nullable
        private ChildScoreMode scoreMode;
        private String type;

        public Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        public Builder innerHits(@Nullable InnerHits value) {
            this.innerHits = value;
            return this;
        }

        public Builder innerHits(Function<InnerHits.Builder, ObjectBuilder<InnerHits>> fn) {
            return this.innerHits(fn.apply(new InnerHits.Builder()).build());
        }

        public Builder maxChildren(@Nullable Integer value) {
            this.maxChildren = value;
            return this;
        }

        public Builder minChildren(@Nullable Integer value) {
            this.minChildren = value;
            return this;
        }

        public Builder query(Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public Builder scoreMode(@Nullable ChildScoreMode value) {
            this.scoreMode = value;
            return this;
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HasChildQuery build() {
            return new HasChildQuery(this);
        }
    }
}

