/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.GeoPolygonPoints;
import co.elastic.clients.elasticsearch._types.query_dsl.GeoValidationMethod;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GeoPolygonQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    private final GeoPolygonPoints polygon;
    @Nullable
    private final GeoValidationMethod validationMethod;
    @Nullable
    private final Boolean ignoreUnmapped;
    public static final JsonpDeserializer<GeoPolygonQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoPolygonQuery::setupGeoPolygonQueryDeserializer, Builder::build);

    public GeoPolygonQuery(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.polygon = Objects.requireNonNull(builder.polygon, "polygon");
        this.validationMethod = builder.validationMethod;
        this.ignoreUnmapped = builder.ignoreUnmapped;
    }

    public GeoPolygonQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "geo_polygon";
    }

    public String field() {
        return this.field;
    }

    public GeoPolygonPoints polygon() {
        return this.polygon;
    }

    @Nullable
    public GeoValidationMethod validationMethod() {
        return this.validationMethod;
    }

    @Nullable
    public Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey(this.field);
        this.polygon.serialize(generator, mapper);
        super.serializeInternal(generator, mapper);
        if (this.validationMethod != null) {
            generator.writeKey("validation_method");
            this.validationMethod.serialize(generator, mapper);
        }
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
    }

    protected static void setupGeoPolygonQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::validationMethod, GeoValidationMethod._DESERIALIZER, "validation_method", new String[0]);
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped", new String[0]);
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field((String)name);
            builder.polygon(GeoPolygonPoints._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoPolygonQuery> {
        private String field;
        private GeoPolygonPoints polygon;
        @Nullable
        private GeoValidationMethod validationMethod;
        @Nullable
        private Boolean ignoreUnmapped;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder polygon(GeoPolygonPoints value) {
            this.polygon = value;
            return this;
        }

        public Builder polygon(Function<GeoPolygonPoints.Builder, ObjectBuilder<GeoPolygonPoints>> fn) {
            return this.polygon(fn.apply(new GeoPolygonPoints.Builder()).build());
        }

        public Builder validationMethod(@Nullable GeoValidationMethod value) {
            this.validationMethod = value;
            return this;
        }

        public Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoPolygonQuery build() {
            return new GeoPolygonQuery(this);
        }
    }
}

