/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.BoundingBox;
import co.elastic.clients.elasticsearch._types.query_dsl.GeoExecution;
import co.elastic.clients.elasticsearch._types.query_dsl.GeoValidationMethod;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GeoBoundingBoxQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    private final BoundingBox boundingBox;
    @Nullable
    private final GeoExecution type;
    @Nullable
    private final GeoValidationMethod validationMethod;
    @Nullable
    private final Boolean ignoreUnmapped;
    public static final JsonpDeserializer<GeoBoundingBoxQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoBoundingBoxQuery::setupGeoBoundingBoxQueryDeserializer, Builder::build);

    public GeoBoundingBoxQuery(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.boundingBox = Objects.requireNonNull(builder.boundingBox, "bounding_box");
        this.type = builder.type;
        this.validationMethod = builder.validationMethod;
        this.ignoreUnmapped = builder.ignoreUnmapped;
    }

    public GeoBoundingBoxQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "geo_bounding_box";
    }

    public String field() {
        return this.field;
    }

    public BoundingBox boundingBox() {
        return this.boundingBox;
    }

    @Nullable
    public GeoExecution type() {
        return this.type;
    }

    @Nullable
    public GeoValidationMethod validationMethod() {
        return this.validationMethod;
    }

    @Nullable
    public Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey(this.field);
        this.boundingBox.serialize(generator, mapper);
        super.serializeInternal(generator, mapper);
        if (this.type != null) {
            generator.writeKey("type");
            this.type.serialize(generator, mapper);
        }
        if (this.validationMethod != null) {
            generator.writeKey("validation_method");
            this.validationMethod.serialize(generator, mapper);
        }
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
    }

    protected static void setupGeoBoundingBoxQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::type, GeoExecution._DESERIALIZER, "type", new String[0]);
        op.add(Builder::validationMethod, GeoValidationMethod._DESERIALIZER, "validation_method", new String[0]);
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped", new String[0]);
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field((String)name);
            builder.boundingBox(BoundingBox._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoBoundingBoxQuery> {
        private String field;
        private BoundingBox boundingBox;
        @Nullable
        private GeoExecution type;
        @Nullable
        private GeoValidationMethod validationMethod;
        @Nullable
        private Boolean ignoreUnmapped;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder boundingBox(BoundingBox value) {
            this.boundingBox = value;
            return this;
        }

        public Builder boundingBox(Function<BoundingBox.Builder, ObjectBuilder<BoundingBox>> fn) {
            return this.boundingBox(fn.apply(new BoundingBox.Builder()).build());
        }

        public Builder type(@Nullable GeoExecution value) {
            this.type = value;
            return this;
        }

        public Builder validationMethod(@Nullable GeoValidationMethod value) {
            this.validationMethod = value;
            return this;
        }

        public Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoBoundingBoxQuery build() {
            return new GeoBoundingBoxQuery(this);
        }
    }
}

