/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.FieldValueFactorModifier;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScoreVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.ScoreFunctionBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FieldValueFactorScoreFunction
extends ScoreFunctionBase
implements FunctionScoreVariant {
    private final String field;
    @Nullable
    private final Double factor;
    @Nullable
    private final Double missing;
    @Nullable
    private final FieldValueFactorModifier modifier;
    public static final JsonpDeserializer<FieldValueFactorScoreFunction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldValueFactorScoreFunction::setupFieldValueFactorScoreFunctionDeserializer, Builder::build);

    public FieldValueFactorScoreFunction(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.factor = builder.factor;
        this.missing = builder.missing;
        this.modifier = builder.modifier;
    }

    public FieldValueFactorScoreFunction(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "field_value_factor";
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public Double factor() {
        return this.factor;
    }

    @Nullable
    public Double missing() {
        return this.missing;
    }

    @Nullable
    public FieldValueFactorModifier modifier() {
        return this.modifier;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.factor != null) {
            generator.writeKey("factor");
            generator.write(this.factor.doubleValue());
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.write(this.missing.doubleValue());
        }
        if (this.modifier != null) {
            generator.writeKey("modifier");
            this.modifier.serialize(generator, mapper);
        }
    }

    protected static void setupFieldValueFactorScoreFunctionDeserializer(DelegatingDeserializer<Builder> op) {
        ScoreFunctionBase.setupScoreFunctionBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::factor, JsonpDeserializer.doubleDeserializer(), "factor", new String[0]);
        op.add(Builder::missing, JsonpDeserializer.doubleDeserializer(), "missing", new String[0]);
        op.add(Builder::modifier, FieldValueFactorModifier._DESERIALIZER, "modifier", new String[0]);
    }

    public static class Builder
    extends ScoreFunctionBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FieldValueFactorScoreFunction> {
        private String field;
        @Nullable
        private Double factor;
        @Nullable
        private Double missing;
        @Nullable
        private FieldValueFactorModifier modifier;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder factor(@Nullable Double value) {
            this.factor = value;
            return this;
        }

        public Builder missing(@Nullable Double value) {
            this.missing = value;
            return this;
        }

        public Builder modifier(@Nullable FieldValueFactorModifier value) {
            this.modifier = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FieldValueFactorScoreFunction build() {
            return new FieldValueFactorScoreFunction(this);
        }
    }
}

