/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DisMaxQuery
extends QueryBase
implements QueryVariant {
    private final List<Query> queries;
    @Nullable
    private final Double tieBreaker;
    public static final JsonpDeserializer<DisMaxQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DisMaxQuery::setupDisMaxQueryDeserializer, Builder::build);

    public DisMaxQuery(Builder builder) {
        super(builder);
        this.queries = ModelTypeHelper.unmodifiableNonNull(builder.queries, "queries");
        this.tieBreaker = builder.tieBreaker;
    }

    public DisMaxQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "dis_max";
    }

    public List<Query> queries() {
        return this.queries;
    }

    @Nullable
    public Double tieBreaker() {
        return this.tieBreaker;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("queries");
        generator.writeStartArray();
        for (Query item0 : this.queries) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.tieBreaker != null) {
            generator.writeKey("tie_breaker");
            generator.write(this.tieBreaker.doubleValue());
        }
    }

    protected static void setupDisMaxQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::queries, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "queries", new String[0]);
        op.add(Builder::tieBreaker, JsonpDeserializer.doubleDeserializer(), "tie_breaker", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DisMaxQuery> {
        private List<Query> queries;
        @Nullable
        private Double tieBreaker;

        public Builder queries(List<Query> value) {
            this.queries = value;
            return this;
        }

        public Builder queries(Query ... value) {
            this.queries = Arrays.asList(value);
            return this;
        }

        public Builder addQueries(Query value) {
            if (this.queries == null) {
                this.queries = new ArrayList<Query>();
            }
            this.queries.add(value);
            return this;
        }

        public Builder queries(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.queries(fn.apply(new Query.Builder()).build());
        }

        public Builder addQueries(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.addQueries(fn.apply(new Query.Builder()).build());
        }

        public Builder tieBreaker(@Nullable Double value) {
            this.tieBreaker = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DisMaxQuery build() {
            return new DisMaxQuery(this);
        }
    }
}

