/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TokenCountProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final String analyzer;
    @Nullable
    private final Double boost;
    @Nullable
    private final Boolean index;
    @Nullable
    private final Double nullValue;
    @Nullable
    private final Boolean enablePositionIncrements;
    public static final JsonpDeserializer<TokenCountProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TokenCountProperty::setupTokenCountPropertyDeserializer, Builder::build);

    public TokenCountProperty(Builder builder) {
        super(builder);
        this.analyzer = builder.analyzer;
        this.boost = builder.boost;
        this.index = builder.index;
        this.nullValue = builder.nullValue;
        this.enablePositionIncrements = builder.enablePositionIncrements;
    }

    public TokenCountProperty(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "token_count";
    }

    @Nullable
    public String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public Double boost() {
        return this.boost;
    }

    @Nullable
    public Boolean index() {
        return this.index;
    }

    @Nullable
    public Double nullValue() {
        return this.nullValue;
    }

    @Nullable
    public Boolean enablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "token_count");
        super.serializeInternal(generator, mapper);
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue.doubleValue());
        }
        if (this.enablePositionIncrements != null) {
            generator.writeKey("enable_position_increments");
            generator.write(this.enablePositionIncrements.booleanValue());
        }
    }

    protected static void setupTokenCountPropertyDeserializer(DelegatingDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer", new String[0]);
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost", new String[0]);
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index", new String[0]);
        op.add(Builder::nullValue, JsonpDeserializer.doubleDeserializer(), "null_value", new String[0]);
        op.add(Builder::enablePositionIncrements, JsonpDeserializer.booleanDeserializer(), "enable_position_increments", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TokenCountProperty> {
        @Nullable
        private String analyzer;
        @Nullable
        private Double boost;
        @Nullable
        private Boolean index;
        @Nullable
        private Double nullValue;
        @Nullable
        private Boolean enablePositionIncrements;

        public Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public Builder boost(@Nullable Double value) {
            this.boost = value;
            return this;
        }

        public Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public Builder nullValue(@Nullable Double value) {
            this.nullValue = value;
            return this;
        }

        public Builder enablePositionIncrements(@Nullable Boolean value) {
            this.enablePositionIncrements = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TokenCountProperty build() {
            return new TokenCountProperty(this);
        }
    }
}

