/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SuggestContext
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final String path;
    private final String type;
    @Nullable
    private final String precision;
    public static final JsonpDeserializer<SuggestContext> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SuggestContext::setupSuggestContextDeserializer, Builder::build);

    public SuggestContext(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.path = builder.path;
        this.type = Objects.requireNonNull(builder.type, "type");
        this.precision = builder.precision;
    }

    public SuggestContext(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public String path() {
        return this.path;
    }

    public String type() {
        return this.type;
    }

    @Nullable
    public String precision() {
        return this.precision;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (this.path != null) {
            generator.writeKey("path");
            generator.write(this.path);
        }
        generator.writeKey("type");
        generator.write(this.type);
        if (this.precision != null) {
            generator.writeKey("precision");
            generator.write(this.precision);
        }
    }

    protected static void setupSuggestContextDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
        op.add(Builder::precision, JsonpDeserializer.stringDeserializer(), "precision", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SuggestContext> {
        private String name;
        @Nullable
        private String path;
        private String type;
        @Nullable
        private String precision;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder path(@Nullable String value) {
            this.path = value;
            return this;
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        public Builder precision(@Nullable String value) {
            this.precision = value;
            return this;
        }

        @Override
        public SuggestContext build() {
            return new SuggestContext(this);
        }
    }
}

