/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.elasticsearch._types.mapping.ShapeOrientation;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ShapeProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean coerce;
    @Nullable
    private final Boolean ignoreMalformed;
    @Nullable
    private final Boolean ignoreZValue;
    @Nullable
    private final ShapeOrientation orientation;
    public static final JsonpDeserializer<ShapeProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShapeProperty::setupShapePropertyDeserializer, Builder::build);

    public ShapeProperty(Builder builder) {
        super(builder);
        this.coerce = builder.coerce;
        this.ignoreMalformed = builder.ignoreMalformed;
        this.ignoreZValue = builder.ignoreZValue;
        this.orientation = builder.orientation;
    }

    public ShapeProperty(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "shape";
    }

    @Nullable
    public Boolean coerce() {
        return this.coerce;
    }

    @Nullable
    public Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Nullable
    public Boolean ignoreZValue() {
        return this.ignoreZValue;
    }

    @Nullable
    public ShapeOrientation orientation() {
        return this.orientation;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "shape");
        super.serializeInternal(generator, mapper);
        if (this.coerce != null) {
            generator.writeKey("coerce");
            generator.write(this.coerce.booleanValue());
        }
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed.booleanValue());
        }
        if (this.ignoreZValue != null) {
            generator.writeKey("ignore_z_value");
            generator.write(this.ignoreZValue.booleanValue());
        }
        if (this.orientation != null) {
            generator.writeKey("orientation");
            this.orientation.serialize(generator, mapper);
        }
    }

    protected static void setupShapePropertyDeserializer(DelegatingDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::coerce, JsonpDeserializer.booleanDeserializer(), "coerce", new String[0]);
        op.add(Builder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed", new String[0]);
        op.add(Builder::ignoreZValue, JsonpDeserializer.booleanDeserializer(), "ignore_z_value", new String[0]);
        op.add(Builder::orientation, ShapeOrientation._DESERIALIZER, "orientation", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ShapeProperty> {
        @Nullable
        private Boolean coerce;
        @Nullable
        private Boolean ignoreMalformed;
        @Nullable
        private Boolean ignoreZValue;
        @Nullable
        private ShapeOrientation orientation;

        public Builder coerce(@Nullable Boolean value) {
            this.coerce = value;
            return this;
        }

        public Builder ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return this;
        }

        public Builder ignoreZValue(@Nullable Boolean value) {
            this.ignoreZValue = value;
            return this;
        }

        public Builder orientation(@Nullable ShapeOrientation value) {
            this.orientation = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShapeProperty build() {
            return new ShapeProperty(this);
        }
    }
}

