/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.AggregateMetricDoubleProperty;
import co.elastic.clients.elasticsearch._types.mapping.BinaryProperty;
import co.elastic.clients.elasticsearch._types.mapping.BooleanProperty;
import co.elastic.clients.elasticsearch._types.mapping.CompletionProperty;
import co.elastic.clients.elasticsearch._types.mapping.ConstantKeywordProperty;
import co.elastic.clients.elasticsearch._types.mapping.DateNanosProperty;
import co.elastic.clients.elasticsearch._types.mapping.DateProperty;
import co.elastic.clients.elasticsearch._types.mapping.DateRangeProperty;
import co.elastic.clients.elasticsearch._types.mapping.DenseVectorProperty;
import co.elastic.clients.elasticsearch._types.mapping.DoubleRangeProperty;
import co.elastic.clients.elasticsearch._types.mapping.FieldAliasProperty;
import co.elastic.clients.elasticsearch._types.mapping.FlattenedProperty;
import co.elastic.clients.elasticsearch._types.mapping.FloatRangeProperty;
import co.elastic.clients.elasticsearch._types.mapping.GeoPointProperty;
import co.elastic.clients.elasticsearch._types.mapping.GeoShapeProperty;
import co.elastic.clients.elasticsearch._types.mapping.HistogramProperty;
import co.elastic.clients.elasticsearch._types.mapping.IntegerRangeProperty;
import co.elastic.clients.elasticsearch._types.mapping.IpProperty;
import co.elastic.clients.elasticsearch._types.mapping.IpRangeProperty;
import co.elastic.clients.elasticsearch._types.mapping.JoinProperty;
import co.elastic.clients.elasticsearch._types.mapping.KeywordProperty;
import co.elastic.clients.elasticsearch._types.mapping.LongRangeProperty;
import co.elastic.clients.elasticsearch._types.mapping.Murmur3HashProperty;
import co.elastic.clients.elasticsearch._types.mapping.NestedProperty;
import co.elastic.clients.elasticsearch._types.mapping.NumberProperty;
import co.elastic.clients.elasticsearch._types.mapping.ObjectProperty;
import co.elastic.clients.elasticsearch._types.mapping.PercolatorProperty;
import co.elastic.clients.elasticsearch._types.mapping.PointProperty;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.elasticsearch._types.mapping.RankFeatureProperty;
import co.elastic.clients.elasticsearch._types.mapping.RankFeaturesProperty;
import co.elastic.clients.elasticsearch._types.mapping.SearchAsYouTypeProperty;
import co.elastic.clients.elasticsearch._types.mapping.ShapeProperty;
import co.elastic.clients.elasticsearch._types.mapping.TextProperty;
import co.elastic.clients.elasticsearch._types.mapping.TokenCountProperty;
import co.elastic.clients.elasticsearch._types.mapping.VersionProperty;
import co.elastic.clients.elasticsearch._types.mapping.WildcardProperty;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class Property
implements TaggedUnion<JsonpSerializable>,
JsonpSerializable {
    public static final String AGGREGATE_METRIC_DOUBLE = "aggregate_metric_double";
    public static final String BINARY = "binary";
    public static final String BOOLEAN = "boolean";
    public static final String COMPLETION = "completion";
    public static final String CONSTANT_KEYWORD = "constant_keyword";
    public static final String DATE_NANOS = "date_nanos";
    public static final String DATE = "date";
    public static final String DATE_RANGE = "date_range";
    public static final String DENSE_VECTOR = "dense_vector";
    public static final String DOUBLE_RANGE = "double_range";
    public static final String ALIAS = "alias";
    public static final String FLATTENED = "flattened";
    public static final String FLOAT_RANGE = "float_range";
    public static final String GEO_POINT = "geo_point";
    public static final String GEO_SHAPE = "geo_shape";
    public static final String HISTOGRAM = "histogram";
    public static final String INTEGER_RANGE = "integer_range";
    public static final String IP = "ip";
    public static final String IP_RANGE = "ip_range";
    public static final String JOIN = "join";
    public static final String KEYWORD = "keyword";
    public static final String LONG_RANGE = "long_range";
    public static final String MURMUR3 = "murmur3";
    public static final String NESTED = "nested";
    public static final String FLOAT = "float";
    public static final String OBJECT = "object";
    public static final String PERCOLATOR = "percolator";
    public static final String POINT = "point";
    public static final String RANK_FEATURE = "rank_feature";
    public static final String RANK_FEATURES = "rank_features";
    public static final String SEARCH_AS_YOU_TYPE = "search_as_you_type";
    public static final String SHAPE = "shape";
    public static final String TEXT = "text";
    public static final String TOKEN_COUNT = "token_count";
    public static final String VERSION = "version";
    public static final String WILDCARD = "wildcard";
    private final String _type;
    private final JsonpSerializable _value;
    public static final JsonpDeserializer<Property> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, Property::setupPropertyDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public JsonpSerializable _get() {
        return this._value;
    }

    public Property(PropertyVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    public <T extends PropertyVariant> Property(ObjectBuilder<T> builder) {
        this((PropertyVariant)builder.build());
    }

    private Property(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public Property(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public AggregateMetricDoubleProperty aggregateMetricDouble() {
        return (AggregateMetricDoubleProperty)TaggedUnionUtils.get(this, AGGREGATE_METRIC_DOUBLE);
    }

    public BinaryProperty binary() {
        return (BinaryProperty)TaggedUnionUtils.get(this, BINARY);
    }

    public BooleanProperty boolean_() {
        return (BooleanProperty)TaggedUnionUtils.get(this, BOOLEAN);
    }

    public CompletionProperty completion() {
        return (CompletionProperty)TaggedUnionUtils.get(this, COMPLETION);
    }

    public ConstantKeywordProperty constantKeyword() {
        return (ConstantKeywordProperty)TaggedUnionUtils.get(this, CONSTANT_KEYWORD);
    }

    public DateNanosProperty dateNanos() {
        return (DateNanosProperty)TaggedUnionUtils.get(this, DATE_NANOS);
    }

    public DateProperty date() {
        return (DateProperty)TaggedUnionUtils.get(this, DATE);
    }

    public DateRangeProperty dateRange() {
        return (DateRangeProperty)TaggedUnionUtils.get(this, DATE_RANGE);
    }

    public DenseVectorProperty denseVector() {
        return (DenseVectorProperty)TaggedUnionUtils.get(this, DENSE_VECTOR);
    }

    public DoubleRangeProperty doubleRange() {
        return (DoubleRangeProperty)TaggedUnionUtils.get(this, DOUBLE_RANGE);
    }

    public FieldAliasProperty alias() {
        return (FieldAliasProperty)TaggedUnionUtils.get(this, ALIAS);
    }

    public FlattenedProperty flattened() {
        return (FlattenedProperty)TaggedUnionUtils.get(this, FLATTENED);
    }

    public FloatRangeProperty floatRange() {
        return (FloatRangeProperty)TaggedUnionUtils.get(this, FLOAT_RANGE);
    }

    public GeoPointProperty geoPoint() {
        return (GeoPointProperty)TaggedUnionUtils.get(this, GEO_POINT);
    }

    public GeoShapeProperty geoShape() {
        return (GeoShapeProperty)TaggedUnionUtils.get(this, GEO_SHAPE);
    }

    public HistogramProperty histogram() {
        return (HistogramProperty)TaggedUnionUtils.get(this, HISTOGRAM);
    }

    public IntegerRangeProperty integerRange() {
        return (IntegerRangeProperty)TaggedUnionUtils.get(this, INTEGER_RANGE);
    }

    public IpProperty ip() {
        return (IpProperty)TaggedUnionUtils.get(this, IP);
    }

    public IpRangeProperty ipRange() {
        return (IpRangeProperty)TaggedUnionUtils.get(this, IP_RANGE);
    }

    public JoinProperty join() {
        return (JoinProperty)TaggedUnionUtils.get(this, JOIN);
    }

    public KeywordProperty keyword() {
        return (KeywordProperty)TaggedUnionUtils.get(this, KEYWORD);
    }

    public LongRangeProperty longRange() {
        return (LongRangeProperty)TaggedUnionUtils.get(this, LONG_RANGE);
    }

    public Murmur3HashProperty murmur3() {
        return (Murmur3HashProperty)TaggedUnionUtils.get(this, MURMUR3);
    }

    public NestedProperty nested() {
        return (NestedProperty)TaggedUnionUtils.get(this, NESTED);
    }

    public NumberProperty float_() {
        return (NumberProperty)TaggedUnionUtils.get(this, FLOAT);
    }

    public ObjectProperty object() {
        return (ObjectProperty)TaggedUnionUtils.get(this, OBJECT);
    }

    public PercolatorProperty percolator() {
        return (PercolatorProperty)TaggedUnionUtils.get(this, PERCOLATOR);
    }

    public PointProperty point() {
        return (PointProperty)TaggedUnionUtils.get(this, POINT);
    }

    public RankFeatureProperty rankFeature() {
        return (RankFeatureProperty)TaggedUnionUtils.get(this, RANK_FEATURE);
    }

    public RankFeaturesProperty rankFeatures() {
        return (RankFeaturesProperty)TaggedUnionUtils.get(this, RANK_FEATURES);
    }

    public SearchAsYouTypeProperty searchAsYouType() {
        return (SearchAsYouTypeProperty)TaggedUnionUtils.get(this, SEARCH_AS_YOU_TYPE);
    }

    public ShapeProperty shape() {
        return (ShapeProperty)TaggedUnionUtils.get(this, SHAPE);
    }

    public TextProperty text() {
        return (TextProperty)TaggedUnionUtils.get(this, TEXT);
    }

    public TokenCountProperty tokenCount() {
        return (TokenCountProperty)TaggedUnionUtils.get(this, TOKEN_COUNT);
    }

    public VersionProperty version() {
        return (VersionProperty)TaggedUnionUtils.get(this, VERSION);
    }

    public WildcardProperty wildcard() {
        return (WildcardProperty)TaggedUnionUtils.get(this, WILDCARD);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this._value.serialize(generator, mapper);
    }

    protected static void setupPropertyDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aggregateMetricDouble, AggregateMetricDoubleProperty._DESERIALIZER, AGGREGATE_METRIC_DOUBLE, new String[0]);
        op.add(Builder::binary, BinaryProperty._DESERIALIZER, BINARY, new String[0]);
        op.add(Builder::boolean_, BooleanProperty._DESERIALIZER, BOOLEAN, new String[0]);
        op.add(Builder::completion, CompletionProperty._DESERIALIZER, COMPLETION, new String[0]);
        op.add(Builder::constantKeyword, ConstantKeywordProperty._DESERIALIZER, CONSTANT_KEYWORD, new String[0]);
        op.add(Builder::dateNanos, DateNanosProperty._DESERIALIZER, DATE_NANOS, new String[0]);
        op.add(Builder::date, DateProperty._DESERIALIZER, DATE, new String[0]);
        op.add(Builder::dateRange, DateRangeProperty._DESERIALIZER, DATE_RANGE, new String[0]);
        op.add(Builder::denseVector, DenseVectorProperty._DESERIALIZER, DENSE_VECTOR, new String[0]);
        op.add(Builder::doubleRange, DoubleRangeProperty._DESERIALIZER, DOUBLE_RANGE, new String[0]);
        op.add(Builder::alias, FieldAliasProperty._DESERIALIZER, ALIAS, new String[0]);
        op.add(Builder::flattened, FlattenedProperty._DESERIALIZER, FLATTENED, new String[0]);
        op.add(Builder::floatRange, FloatRangeProperty._DESERIALIZER, FLOAT_RANGE, new String[0]);
        op.add(Builder::geoPoint, GeoPointProperty._DESERIALIZER, GEO_POINT, new String[0]);
        op.add(Builder::geoShape, GeoShapeProperty._DESERIALIZER, GEO_SHAPE, new String[0]);
        op.add(Builder::histogram, HistogramProperty._DESERIALIZER, HISTOGRAM, new String[0]);
        op.add(Builder::integerRange, IntegerRangeProperty._DESERIALIZER, INTEGER_RANGE, new String[0]);
        op.add(Builder::ip, IpProperty._DESERIALIZER, IP, new String[0]);
        op.add(Builder::ipRange, IpRangeProperty._DESERIALIZER, IP_RANGE, new String[0]);
        op.add(Builder::join, JoinProperty._DESERIALIZER, JOIN, new String[0]);
        op.add(Builder::keyword, KeywordProperty._DESERIALIZER, KEYWORD, new String[0]);
        op.add(Builder::longRange, LongRangeProperty._DESERIALIZER, LONG_RANGE, new String[0]);
        op.add(Builder::murmur3, Murmur3HashProperty._DESERIALIZER, MURMUR3, new String[0]);
        op.add(Builder::nested, NestedProperty._DESERIALIZER, NESTED, new String[0]);
        op.add(Builder::float_, NumberProperty._DESERIALIZER, FLOAT, new String[0]);
        op.add(Builder::object, ObjectProperty._DESERIALIZER, OBJECT, new String[0]);
        op.add(Builder::percolator, PercolatorProperty._DESERIALIZER, PERCOLATOR, new String[0]);
        op.add(Builder::point, PointProperty._DESERIALIZER, POINT, new String[0]);
        op.add(Builder::rankFeature, RankFeatureProperty._DESERIALIZER, RANK_FEATURE, new String[0]);
        op.add(Builder::rankFeatures, RankFeaturesProperty._DESERIALIZER, RANK_FEATURES, new String[0]);
        op.add(Builder::searchAsYouType, SearchAsYouTypeProperty._DESERIALIZER, SEARCH_AS_YOU_TYPE, new String[0]);
        op.add(Builder::shape, ShapeProperty._DESERIALIZER, SHAPE, new String[0]);
        op.add(Builder::text, TextProperty._DESERIALIZER, TEXT, new String[0]);
        op.add(Builder::tokenCount, TokenCountProperty._DESERIALIZER, TOKEN_COUNT, new String[0]);
        op.add(Builder::version, VersionProperty._DESERIALIZER, VERSION, new String[0]);
        op.add(Builder::wildcard, WildcardProperty._DESERIALIZER, WILDCARD, new String[0]);
        op.setTypeProperty("type");
    }

    public static class Builder
    implements ObjectBuilder<Property> {
        private String _type;
        private JsonpSerializable _value;

        public Builder aggregateMetricDouble(AggregateMetricDoubleProperty v) {
            this._type = Property.AGGREGATE_METRIC_DOUBLE;
            this._value = v;
            return this;
        }

        public Builder aggregateMetricDouble(Function<AggregateMetricDoubleProperty.Builder, ObjectBuilder<AggregateMetricDoubleProperty>> f) {
            return this.aggregateMetricDouble(f.apply(new AggregateMetricDoubleProperty.Builder()).build());
        }

        public Builder binary(BinaryProperty v) {
            this._type = Property.BINARY;
            this._value = v;
            return this;
        }

        public Builder binary(Function<BinaryProperty.Builder, ObjectBuilder<BinaryProperty>> f) {
            return this.binary(f.apply(new BinaryProperty.Builder()).build());
        }

        public Builder boolean_(BooleanProperty v) {
            this._type = Property.BOOLEAN;
            this._value = v;
            return this;
        }

        public Builder boolean_(Function<BooleanProperty.Builder, ObjectBuilder<BooleanProperty>> f) {
            return this.boolean_(f.apply(new BooleanProperty.Builder()).build());
        }

        public Builder completion(CompletionProperty v) {
            this._type = Property.COMPLETION;
            this._value = v;
            return this;
        }

        public Builder completion(Function<CompletionProperty.Builder, ObjectBuilder<CompletionProperty>> f) {
            return this.completion(f.apply(new CompletionProperty.Builder()).build());
        }

        public Builder constantKeyword(ConstantKeywordProperty v) {
            this._type = Property.CONSTANT_KEYWORD;
            this._value = v;
            return this;
        }

        public Builder constantKeyword(Function<ConstantKeywordProperty.Builder, ObjectBuilder<ConstantKeywordProperty>> f) {
            return this.constantKeyword(f.apply(new ConstantKeywordProperty.Builder()).build());
        }

        public Builder dateNanos(DateNanosProperty v) {
            this._type = Property.DATE_NANOS;
            this._value = v;
            return this;
        }

        public Builder dateNanos(Function<DateNanosProperty.Builder, ObjectBuilder<DateNanosProperty>> f) {
            return this.dateNanos(f.apply(new DateNanosProperty.Builder()).build());
        }

        public Builder date(DateProperty v) {
            this._type = Property.DATE;
            this._value = v;
            return this;
        }

        public Builder date(Function<DateProperty.Builder, ObjectBuilder<DateProperty>> f) {
            return this.date(f.apply(new DateProperty.Builder()).build());
        }

        public Builder dateRange(DateRangeProperty v) {
            this._type = Property.DATE_RANGE;
            this._value = v;
            return this;
        }

        public Builder dateRange(Function<DateRangeProperty.Builder, ObjectBuilder<DateRangeProperty>> f) {
            return this.dateRange(f.apply(new DateRangeProperty.Builder()).build());
        }

        public Builder denseVector(DenseVectorProperty v) {
            this._type = Property.DENSE_VECTOR;
            this._value = v;
            return this;
        }

        public Builder denseVector(Function<DenseVectorProperty.Builder, ObjectBuilder<DenseVectorProperty>> f) {
            return this.denseVector(f.apply(new DenseVectorProperty.Builder()).build());
        }

        public Builder doubleRange(DoubleRangeProperty v) {
            this._type = Property.DOUBLE_RANGE;
            this._value = v;
            return this;
        }

        public Builder doubleRange(Function<DoubleRangeProperty.Builder, ObjectBuilder<DoubleRangeProperty>> f) {
            return this.doubleRange(f.apply(new DoubleRangeProperty.Builder()).build());
        }

        public Builder alias(FieldAliasProperty v) {
            this._type = Property.ALIAS;
            this._value = v;
            return this;
        }

        public Builder alias(Function<FieldAliasProperty.Builder, ObjectBuilder<FieldAliasProperty>> f) {
            return this.alias(f.apply(new FieldAliasProperty.Builder()).build());
        }

        public Builder flattened(FlattenedProperty v) {
            this._type = Property.FLATTENED;
            this._value = v;
            return this;
        }

        public Builder flattened(Function<FlattenedProperty.Builder, ObjectBuilder<FlattenedProperty>> f) {
            return this.flattened(f.apply(new FlattenedProperty.Builder()).build());
        }

        public Builder floatRange(FloatRangeProperty v) {
            this._type = Property.FLOAT_RANGE;
            this._value = v;
            return this;
        }

        public Builder floatRange(Function<FloatRangeProperty.Builder, ObjectBuilder<FloatRangeProperty>> f) {
            return this.floatRange(f.apply(new FloatRangeProperty.Builder()).build());
        }

        public Builder geoPoint(GeoPointProperty v) {
            this._type = Property.GEO_POINT;
            this._value = v;
            return this;
        }

        public Builder geoPoint(Function<GeoPointProperty.Builder, ObjectBuilder<GeoPointProperty>> f) {
            return this.geoPoint(f.apply(new GeoPointProperty.Builder()).build());
        }

        public Builder geoShape(GeoShapeProperty v) {
            this._type = Property.GEO_SHAPE;
            this._value = v;
            return this;
        }

        public Builder geoShape(Function<GeoShapeProperty.Builder, ObjectBuilder<GeoShapeProperty>> f) {
            return this.geoShape(f.apply(new GeoShapeProperty.Builder()).build());
        }

        public Builder histogram(HistogramProperty v) {
            this._type = Property.HISTOGRAM;
            this._value = v;
            return this;
        }

        public Builder histogram(Function<HistogramProperty.Builder, ObjectBuilder<HistogramProperty>> f) {
            return this.histogram(f.apply(new HistogramProperty.Builder()).build());
        }

        public Builder integerRange(IntegerRangeProperty v) {
            this._type = Property.INTEGER_RANGE;
            this._value = v;
            return this;
        }

        public Builder integerRange(Function<IntegerRangeProperty.Builder, ObjectBuilder<IntegerRangeProperty>> f) {
            return this.integerRange(f.apply(new IntegerRangeProperty.Builder()).build());
        }

        public Builder ip(IpProperty v) {
            this._type = Property.IP;
            this._value = v;
            return this;
        }

        public Builder ip(Function<IpProperty.Builder, ObjectBuilder<IpProperty>> f) {
            return this.ip(f.apply(new IpProperty.Builder()).build());
        }

        public Builder ipRange(IpRangeProperty v) {
            this._type = Property.IP_RANGE;
            this._value = v;
            return this;
        }

        public Builder ipRange(Function<IpRangeProperty.Builder, ObjectBuilder<IpRangeProperty>> f) {
            return this.ipRange(f.apply(new IpRangeProperty.Builder()).build());
        }

        public Builder join(JoinProperty v) {
            this._type = Property.JOIN;
            this._value = v;
            return this;
        }

        public Builder join(Function<JoinProperty.Builder, ObjectBuilder<JoinProperty>> f) {
            return this.join(f.apply(new JoinProperty.Builder()).build());
        }

        public Builder keyword(KeywordProperty v) {
            this._type = Property.KEYWORD;
            this._value = v;
            return this;
        }

        public Builder keyword(Function<KeywordProperty.Builder, ObjectBuilder<KeywordProperty>> f) {
            return this.keyword(f.apply(new KeywordProperty.Builder()).build());
        }

        public Builder longRange(LongRangeProperty v) {
            this._type = Property.LONG_RANGE;
            this._value = v;
            return this;
        }

        public Builder longRange(Function<LongRangeProperty.Builder, ObjectBuilder<LongRangeProperty>> f) {
            return this.longRange(f.apply(new LongRangeProperty.Builder()).build());
        }

        public Builder murmur3(Murmur3HashProperty v) {
            this._type = Property.MURMUR3;
            this._value = v;
            return this;
        }

        public Builder murmur3(Function<Murmur3HashProperty.Builder, ObjectBuilder<Murmur3HashProperty>> f) {
            return this.murmur3(f.apply(new Murmur3HashProperty.Builder()).build());
        }

        public Builder nested(NestedProperty v) {
            this._type = Property.NESTED;
            this._value = v;
            return this;
        }

        public Builder nested(Function<NestedProperty.Builder, ObjectBuilder<NestedProperty>> f) {
            return this.nested(f.apply(new NestedProperty.Builder()).build());
        }

        public Builder float_(NumberProperty v) {
            this._type = Property.FLOAT;
            this._value = v;
            return this;
        }

        public Builder float_(Function<NumberProperty.Builder, ObjectBuilder<NumberProperty>> f) {
            return this.float_(f.apply(new NumberProperty.Builder()).build());
        }

        public Builder object(ObjectProperty v) {
            this._type = Property.OBJECT;
            this._value = v;
            return this;
        }

        public Builder object(Function<ObjectProperty.Builder, ObjectBuilder<ObjectProperty>> f) {
            return this.object(f.apply(new ObjectProperty.Builder()).build());
        }

        public Builder percolator(PercolatorProperty v) {
            this._type = Property.PERCOLATOR;
            this._value = v;
            return this;
        }

        public Builder percolator(Function<PercolatorProperty.Builder, ObjectBuilder<PercolatorProperty>> f) {
            return this.percolator(f.apply(new PercolatorProperty.Builder()).build());
        }

        public Builder point(PointProperty v) {
            this._type = Property.POINT;
            this._value = v;
            return this;
        }

        public Builder point(Function<PointProperty.Builder, ObjectBuilder<PointProperty>> f) {
            return this.point(f.apply(new PointProperty.Builder()).build());
        }

        public Builder rankFeature(RankFeatureProperty v) {
            this._type = Property.RANK_FEATURE;
            this._value = v;
            return this;
        }

        public Builder rankFeature(Function<RankFeatureProperty.Builder, ObjectBuilder<RankFeatureProperty>> f) {
            return this.rankFeature(f.apply(new RankFeatureProperty.Builder()).build());
        }

        public Builder rankFeatures(RankFeaturesProperty v) {
            this._type = Property.RANK_FEATURES;
            this._value = v;
            return this;
        }

        public Builder rankFeatures(Function<RankFeaturesProperty.Builder, ObjectBuilder<RankFeaturesProperty>> f) {
            return this.rankFeatures(f.apply(new RankFeaturesProperty.Builder()).build());
        }

        public Builder searchAsYouType(SearchAsYouTypeProperty v) {
            this._type = Property.SEARCH_AS_YOU_TYPE;
            this._value = v;
            return this;
        }

        public Builder searchAsYouType(Function<SearchAsYouTypeProperty.Builder, ObjectBuilder<SearchAsYouTypeProperty>> f) {
            return this.searchAsYouType(f.apply(new SearchAsYouTypeProperty.Builder()).build());
        }

        public Builder shape(ShapeProperty v) {
            this._type = Property.SHAPE;
            this._value = v;
            return this;
        }

        public Builder shape(Function<ShapeProperty.Builder, ObjectBuilder<ShapeProperty>> f) {
            return this.shape(f.apply(new ShapeProperty.Builder()).build());
        }

        public Builder text(TextProperty v) {
            this._type = Property.TEXT;
            this._value = v;
            return this;
        }

        public Builder text(Function<TextProperty.Builder, ObjectBuilder<TextProperty>> f) {
            return this.text(f.apply(new TextProperty.Builder()).build());
        }

        public Builder tokenCount(TokenCountProperty v) {
            this._type = Property.TOKEN_COUNT;
            this._value = v;
            return this;
        }

        public Builder tokenCount(Function<TokenCountProperty.Builder, ObjectBuilder<TokenCountProperty>> f) {
            return this.tokenCount(f.apply(new TokenCountProperty.Builder()).build());
        }

        public Builder version(VersionProperty v) {
            this._type = Property.VERSION;
            this._value = v;
            return this;
        }

        public Builder version(Function<VersionProperty.Builder, ObjectBuilder<VersionProperty>> f) {
            return this.version(f.apply(new VersionProperty.Builder()).build());
        }

        public Builder wildcard(WildcardProperty v) {
            this._type = Property.WILDCARD;
            this._value = v;
            return this;
        }

        public Builder wildcard(Function<WildcardProperty.Builder, ObjectBuilder<WildcardProperty>> f) {
            return this.wildcard(f.apply(new WildcardProperty.Builder()).build());
        }

        @Override
        public Property build() {
            return new Property(this);
        }
    }
}

