/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IpProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final Double boost;
    @Nullable
    private final Boolean index;
    @Nullable
    private final String nullValue;
    public static final JsonpDeserializer<IpProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IpProperty::setupIpPropertyDeserializer, Builder::build);

    public IpProperty(Builder builder) {
        super(builder);
        this.boost = builder.boost;
        this.index = builder.index;
        this.nullValue = builder.nullValue;
    }

    public IpProperty(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "ip";
    }

    @Nullable
    public Double boost() {
        return this.boost;
    }

    @Nullable
    public Boolean index() {
        return this.index;
    }

    @Nullable
    public String nullValue() {
        return this.nullValue;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "ip");
        super.serializeInternal(generator, mapper);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue);
        }
    }

    protected static void setupIpPropertyDeserializer(DelegatingDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost", new String[0]);
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index", new String[0]);
        op.add(Builder::nullValue, JsonpDeserializer.stringDeserializer(), "null_value", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IpProperty> {
        @Nullable
        private Double boost;
        @Nullable
        private Boolean index;
        @Nullable
        private String nullValue;

        public Builder boost(@Nullable Double value) {
            this.boost = value;
            return this;
        }

        public Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public Builder nullValue(@Nullable String value) {
            this.nullValue = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IpProperty build() {
            return new IpProperty(this);
        }
    }
}

