/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class TruncateTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final int length;
    public static final JsonpDeserializer<TruncateTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TruncateTokenFilter::setupTruncateTokenFilterDeserializer, Builder::build);

    public TruncateTokenFilter(Builder builder) {
        super(builder);
        this.length = Objects.requireNonNull(builder.length, "length");
    }

    public TruncateTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "truncate";
    }

    public int length() {
        return this.length;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "truncate");
        super.serializeInternal(generator, mapper);
        generator.writeKey("length");
        generator.write(this.length);
    }

    protected static void setupTruncateTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::length, JsonpDeserializer.integerDeserializer(), "length", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TruncateTokenFilter> {
        private Integer length;

        public Builder length(int value) {
            this.length = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TruncateTokenFilter build() {
            return new TruncateTokenFilter(this);
        }
    }
}

