/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.CharFilterVariant;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class PatternReplaceTokenFilter
extends TokenFilterBase
implements CharFilterVariant,
TokenFilterVariant {
    private final String flags;
    private final String pattern;
    private final String replacement;
    public static final JsonpDeserializer<PatternReplaceTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PatternReplaceTokenFilter::setupPatternReplaceTokenFilterDeserializer, Builder::build);

    public PatternReplaceTokenFilter(Builder builder) {
        super(builder);
        this.flags = Objects.requireNonNull(builder.flags, "flags");
        this.pattern = Objects.requireNonNull(builder.pattern, "pattern");
        this.replacement = Objects.requireNonNull(builder.replacement, "replacement");
    }

    public PatternReplaceTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "pattern_replace";
    }

    public String flags() {
        return this.flags;
    }

    public String pattern() {
        return this.pattern;
    }

    public String replacement() {
        return this.replacement;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "pattern_replace");
        super.serializeInternal(generator, mapper);
        generator.writeKey("flags");
        generator.write(this.flags);
        generator.writeKey("pattern");
        generator.write(this.pattern);
        generator.writeKey("replacement");
        generator.write(this.replacement);
    }

    protected static void setupPatternReplaceTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::flags, JsonpDeserializer.stringDeserializer(), "flags", new String[0]);
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern", new String[0]);
        op.add(Builder::replacement, JsonpDeserializer.stringDeserializer(), "replacement", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PatternReplaceTokenFilter> {
        private String flags;
        private String pattern;
        private String replacement;

        public Builder flags(String value) {
            this.flags = value;
            return this;
        }

        public Builder pattern(String value) {
            this.pattern = value;
            return this;
        }

        public Builder replacement(String value) {
            this.replacement = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PatternReplaceTokenFilter build() {
            return new PatternReplaceTokenFilter(this);
        }
    }
}

