/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenizerBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class PathHierarchyTokenizer
extends TokenizerBase
implements TokenizerVariant {
    private final int bufferSize;
    private final String delimiter;
    private final String replacement;
    private final boolean reverse;
    private final int skip;
    public static final JsonpDeserializer<PathHierarchyTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PathHierarchyTokenizer::setupPathHierarchyTokenizerDeserializer, Builder::build);

    public PathHierarchyTokenizer(Builder builder) {
        super(builder);
        this.bufferSize = Objects.requireNonNull(builder.bufferSize, "buffer_size");
        this.delimiter = Objects.requireNonNull(builder.delimiter, "delimiter");
        this.replacement = Objects.requireNonNull(builder.replacement, "replacement");
        this.reverse = Objects.requireNonNull(builder.reverse, "reverse");
        this.skip = Objects.requireNonNull(builder.skip, "skip");
    }

    public PathHierarchyTokenizer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "path_hierarchy";
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public String replacement() {
        return this.replacement;
    }

    public boolean reverse() {
        return this.reverse;
    }

    public int skip() {
        return this.skip;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "path_hierarchy");
        super.serializeInternal(generator, mapper);
        generator.writeKey("buffer_size");
        generator.write(this.bufferSize);
        generator.writeKey("delimiter");
        generator.write(this.delimiter);
        generator.writeKey("replacement");
        generator.write(this.replacement);
        generator.writeKey("reverse");
        generator.write(this.reverse);
        generator.writeKey("skip");
        generator.write(this.skip);
    }

    protected static void setupPathHierarchyTokenizerDeserializer(DelegatingDeserializer<Builder> op) {
        TokenizerBase.setupTokenizerBaseDeserializer(op);
        op.add(Builder::bufferSize, JsonpDeserializer.integerDeserializer(), "buffer_size", new String[0]);
        op.add(Builder::delimiter, JsonpDeserializer.stringDeserializer(), "delimiter", new String[0]);
        op.add(Builder::replacement, JsonpDeserializer.stringDeserializer(), "replacement", new String[0]);
        op.add(Builder::reverse, JsonpDeserializer.booleanDeserializer(), "reverse", new String[0]);
        op.add(Builder::skip, JsonpDeserializer.integerDeserializer(), "skip", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PathHierarchyTokenizer> {
        private Integer bufferSize;
        private String delimiter;
        private String replacement;
        private Boolean reverse;
        private Integer skip;

        public Builder bufferSize(int value) {
            this.bufferSize = value;
            return this;
        }

        public Builder delimiter(String value) {
            this.delimiter = value;
            return this;
        }

        public Builder replacement(String value) {
            this.replacement = value;
            return this;
        }

        public Builder reverse(boolean value) {
            this.reverse = value;
            return this;
        }

        public Builder skip(int value) {
            this.skip = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PathHierarchyTokenizer build() {
            return new PathHierarchyTokenizer(this);
        }
    }
}

