/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.KeepTypesMode;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class KeepTypesTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final KeepTypesMode mode;
    private final List<String> types;
    public static final JsonpDeserializer<KeepTypesTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeepTypesTokenFilter::setupKeepTypesTokenFilterDeserializer, Builder::build);

    public KeepTypesTokenFilter(Builder builder) {
        super(builder);
        this.mode = Objects.requireNonNull(builder.mode, "mode");
        this.types = ModelTypeHelper.unmodifiableNonNull(builder.types, "types");
    }

    public KeepTypesTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "keep_types";
    }

    public KeepTypesMode mode() {
        return this.mode;
    }

    public List<String> types() {
        return this.types;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "keep_types");
        super.serializeInternal(generator, mapper);
        generator.writeKey("mode");
        this.mode.serialize(generator, mapper);
        generator.writeKey("types");
        generator.writeStartArray();
        for (String item0 : this.types) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupKeepTypesTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::mode, KeepTypesMode._DESERIALIZER, "mode", new String[0]);
        op.add(Builder::types, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "types", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KeepTypesTokenFilter> {
        private KeepTypesMode mode;
        private List<String> types;

        public Builder mode(KeepTypesMode value) {
            this.mode = value;
            return this;
        }

        public Builder types(List<String> value) {
            this.types = value;
            return this;
        }

        public Builder types(String ... value) {
            this.types = Arrays.asList(value);
            return this;
        }

        public Builder addTypes(String value) {
            if (this.types == null) {
                this.types = new ArrayList<String>();
            }
            this.types.add(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KeepTypesTokenFilter build() {
            return new KeepTypesTokenFilter(this);
        }
    }
}

