/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ElisionTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final List<String> articles;
    private final boolean articlesCase;
    public static final JsonpDeserializer<ElisionTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ElisionTokenFilter::setupElisionTokenFilterDeserializer, Builder::build);

    public ElisionTokenFilter(Builder builder) {
        super(builder);
        this.articles = ModelTypeHelper.unmodifiableNonNull(builder.articles, "articles");
        this.articlesCase = Objects.requireNonNull(builder.articlesCase, "articles_case");
    }

    public ElisionTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "elision";
    }

    public List<String> articles() {
        return this.articles;
    }

    public boolean articlesCase() {
        return this.articlesCase;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "elision");
        super.serializeInternal(generator, mapper);
        generator.writeKey("articles");
        generator.writeStartArray();
        for (String item0 : this.articles) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("articles_case");
        generator.write(this.articlesCase);
    }

    protected static void setupElisionTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::articles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "articles", new String[0]);
        op.add(Builder::articlesCase, JsonpDeserializer.booleanDeserializer(), "articles_case", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ElisionTokenFilter> {
        private List<String> articles;
        private Boolean articlesCase;

        public Builder articles(List<String> value) {
            this.articles = value;
            return this;
        }

        public Builder articles(String ... value) {
            this.articles = Arrays.asList(value);
            return this;
        }

        public Builder addArticles(String value) {
            if (this.articles == null) {
                this.articles = new ArrayList<String>();
            }
            this.articles.add(value);
            return this;
        }

        public Builder articlesCase(boolean value) {
            this.articlesCase = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ElisionTokenFilter build() {
            return new ElisionTokenFilter(this);
        }
    }
}

