/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class AsciiFoldingTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final boolean preserveOriginal;
    public static final JsonpDeserializer<AsciiFoldingTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AsciiFoldingTokenFilter::setupAsciiFoldingTokenFilterDeserializer, Builder::build);

    public AsciiFoldingTokenFilter(Builder builder) {
        super(builder);
        this.preserveOriginal = Objects.requireNonNull(builder.preserveOriginal, "preserve_original");
    }

    public AsciiFoldingTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "asciifolding";
    }

    public boolean preserveOriginal() {
        return this.preserveOriginal;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "asciifolding");
        super.serializeInternal(generator, mapper);
        generator.writeKey("preserve_original");
        generator.write(this.preserveOriginal);
    }

    protected static void setupAsciiFoldingTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::preserveOriginal, JsonpDeserializer.booleanDeserializer(), "preserve_original", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AsciiFoldingTokenFilter> {
        private Boolean preserveOriginal;

        public Builder preserveOriginal(boolean value) {
            this.preserveOriginal = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AsciiFoldingTokenFilter build() {
            return new AsciiFoldingTokenFilter(this);
        }
    }
}

