/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.DateInterval;
import co.elastic.clients.elasticsearch._types.aggregations.FormatMetricAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.RateMode;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RateAggregation
extends FormatMetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final DateInterval unit;
    @Nullable
    private final RateMode mode;
    public static final JsonpDeserializer<RateAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RateAggregation::setupRateAggregationDeserializer, Builder::build);

    public RateAggregation(Builder builder) {
        super(builder);
        this.unit = builder.unit;
        this.mode = builder.mode;
    }

    public RateAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "rate";
    }

    @Nullable
    public DateInterval unit() {
        return this.unit;
    }

    @Nullable
    public RateMode mode() {
        return this.mode;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.unit != null) {
            generator.writeKey("unit");
            this.unit.serialize(generator, mapper);
        }
        if (this.mode != null) {
            generator.writeKey("mode");
            this.mode.serialize(generator, mapper);
        }
    }

    protected static void setupRateAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        FormatMetricAggregationBase.setupFormatMetricAggregationBaseDeserializer(op);
        op.add(Builder::unit, DateInterval._DESERIALIZER, "unit", new String[0]);
        op.add(Builder::mode, RateMode._DESERIALIZER, "mode", new String[0]);
    }

    public static class Builder
    extends FormatMetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RateAggregation> {
        @Nullable
        private DateInterval unit;
        @Nullable
        private RateMode mode;

        public Builder unit(@Nullable DateInterval value) {
            this.unit = value;
            return this;
        }

        public Builder mode(@Nullable RateMode value) {
            this.mode = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RateAggregation build() {
            return new RateAggregation(this);
        }
    }
}

