/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.GapPolicy;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class PipelineAggregationBase
extends AggregationBase {
    @Nullable
    private final String bucketsPath;
    @Nullable
    private final String format;
    @Nullable
    private final GapPolicy gapPolicy;

    public PipelineAggregationBase(AbstractBuilder<?> builder) {
        super(builder);
        this.bucketsPath = ((AbstractBuilder)builder).bucketsPath;
        this.format = ((AbstractBuilder)builder).format;
        this.gapPolicy = ((AbstractBuilder)builder).gapPolicy;
    }

    @Nullable
    public String bucketsPath() {
        return this.bucketsPath;
    }

    @Nullable
    public String format() {
        return this.format;
    }

    @Nullable
    public GapPolicy gapPolicy() {
        return this.gapPolicy;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.bucketsPath != null) {
            generator.writeKey("buckets_path");
            generator.write(this.bucketsPath);
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.gapPolicy != null) {
            generator.writeKey("gap_policy");
            this.gapPolicy.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupPipelineAggregationBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        AggregationBase.setupAggregationBaseDeserializer(op);
        op.add(AbstractBuilder::bucketsPath, JsonpDeserializer.stringDeserializer(), "buckets_path", new String[0]);
        op.add(AbstractBuilder::format, JsonpDeserializer.stringDeserializer(), "format", new String[0]);
        op.add(AbstractBuilder::gapPolicy, GapPolicy._DESERIALIZER, "gap_policy", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregationBase.AbstractBuilder<BuilderT> {
        @Nullable
        private String bucketsPath;
        @Nullable
        private String format;
        @Nullable
        private GapPolicy gapPolicy;

        protected AbstractBuilder() {
        }

        public BuilderT bucketsPath(@Nullable String value) {
            this.bucketsPath = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT format(@Nullable String value) {
            this.format = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT gapPolicy(@Nullable GapPolicy value) {
            this.gapPolicy = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

