/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class MetricAggregationBase
implements JsonpSerializable {
    @Nullable
    private final String field;
    @Nullable
    private final String missing;
    @Nullable
    private final JsonValue script;

    public MetricAggregationBase(AbstractBuilder<?> builder) {
        this.field = ((AbstractBuilder)builder).field;
        this.missing = ((AbstractBuilder)builder).missing;
        this.script = ((AbstractBuilder)builder).script;
    }

    @Nullable
    public String field() {
        return this.field;
    }

    @Nullable
    public String missing() {
        return this.missing;
    }

    @Nullable
    public JsonValue script() {
        return this.script;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.write(this.missing);
        }
        if (this.script != null) {
            generator.writeKey("script");
            generator.write(this.script);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupMetricAggregationBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(AbstractBuilder::missing, JsonpDeserializer.stringDeserializer(), "missing", new String[0]);
        op.add(AbstractBuilder::script, JsonpDeserializer.jsonValueDeserializer(), "script", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        @Nullable
        private String field;
        @Nullable
        private String missing;
        @Nullable
        private JsonValue script;

        protected AbstractBuilder() {
        }

        public BuilderT field(@Nullable String value) {
            this.field = value;
            return this.self();
        }

        public BuilderT missing(@Nullable String value) {
            this.missing = value;
            return this.self();
        }

        public BuilderT script(@Nullable JsonValue value) {
            this.script = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

