/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.InferenceConfig;
import co.elastic.clients.elasticsearch._types.aggregations.PipelineAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class InferenceAggregation
extends PipelineAggregationBase
implements AggregationVariant {
    private final String modelId;
    @Nullable
    private final InferenceConfig inferenceConfig;
    public static final JsonpDeserializer<InferenceAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceAggregation::setupInferenceAggregationDeserializer, Builder::build);

    public InferenceAggregation(Builder builder) {
        super(builder);
        this.modelId = Objects.requireNonNull(builder.modelId, "model_id");
        this.inferenceConfig = builder.inferenceConfig;
    }

    public InferenceAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "inference";
    }

    public String modelId() {
        return this.modelId;
    }

    @Nullable
    public InferenceConfig inferenceConfig() {
        return this.inferenceConfig;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("model_id");
        generator.write(this.modelId);
        if (this.inferenceConfig != null) {
            generator.writeKey("inference_config");
            this.inferenceConfig.serialize(generator, mapper);
        }
    }

    protected static void setupInferenceAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        PipelineAggregationBase.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id", new String[0]);
        op.add(Builder::inferenceConfig, InferenceConfig._DESERIALIZER, "inference_config", new String[0]);
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<InferenceAggregation> {
        private String modelId;
        @Nullable
        private InferenceConfig inferenceConfig;

        public Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public Builder inferenceConfig(@Nullable InferenceConfig value) {
            this.inferenceConfig = value;
            return this;
        }

        public Builder inferenceConfig(Function<InferenceConfig.Builder, ObjectBuilder<InferenceConfig>> fn) {
            return this.inferenceConfig(fn.apply(new InferenceConfig.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InferenceAggregation build() {
            return new InferenceAggregation(this);
        }
    }
}

