/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.MetricAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GeoBoundsAggregation
extends MetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Boolean wrapLongitude;
    public static final JsonpDeserializer<GeoBoundsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoBoundsAggregation::setupGeoBoundsAggregationDeserializer, Builder::build);

    public GeoBoundsAggregation(Builder builder) {
        super(builder);
        this.wrapLongitude = builder.wrapLongitude;
    }

    public GeoBoundsAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "geo_bounds";
    }

    @Nullable
    public Boolean wrapLongitude() {
        return this.wrapLongitude;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.wrapLongitude != null) {
            generator.writeKey("wrap_longitude");
            generator.write(this.wrapLongitude.booleanValue());
        }
    }

    protected static void setupGeoBoundsAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        MetricAggregationBase.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::wrapLongitude, JsonpDeserializer.booleanDeserializer(), "wrap_longitude", new String[0]);
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoBoundsAggregation> {
        @Nullable
        private Boolean wrapLongitude;

        public Builder wrapLongitude(@Nullable Boolean value) {
            this.wrapLongitude = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoBoundsAggregation build() {
            return new GeoBoundsAggregation(this);
        }
    }
}

