/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FiltersAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final JsonValue filters;
    @Nullable
    private final Boolean otherBucket;
    @Nullable
    private final String otherBucketKey;
    @Nullable
    private final Boolean keyed;
    public static final JsonpDeserializer<FiltersAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FiltersAggregation::setupFiltersAggregationDeserializer, Builder::build);

    public FiltersAggregation(Builder builder) {
        super(builder);
        this.filters = builder.filters;
        this.otherBucket = builder.otherBucket;
        this.otherBucketKey = builder.otherBucketKey;
        this.keyed = builder.keyed;
    }

    public FiltersAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "filters";
    }

    @Nullable
    public JsonValue filters() {
        return this.filters;
    }

    @Nullable
    public Boolean otherBucket() {
        return this.otherBucket;
    }

    @Nullable
    public String otherBucketKey() {
        return this.otherBucketKey;
    }

    @Nullable
    public Boolean keyed() {
        return this.keyed;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.filters != null) {
            generator.writeKey("filters");
            generator.write(this.filters);
        }
        if (this.otherBucket != null) {
            generator.writeKey("other_bucket");
            generator.write(this.otherBucket.booleanValue());
        }
        if (this.otherBucketKey != null) {
            generator.writeKey("other_bucket_key");
            generator.write(this.otherBucketKey);
        }
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed.booleanValue());
        }
    }

    protected static void setupFiltersAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::filters, JsonpDeserializer.jsonValueDeserializer(), "filters", new String[0]);
        op.add(Builder::otherBucket, JsonpDeserializer.booleanDeserializer(), "other_bucket", new String[0]);
        op.add(Builder::otherBucketKey, JsonpDeserializer.stringDeserializer(), "other_bucket_key", new String[0]);
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed", new String[0]);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FiltersAggregation> {
        @Nullable
        private JsonValue filters;
        @Nullable
        private Boolean otherBucket;
        @Nullable
        private String otherBucketKey;
        @Nullable
        private Boolean keyed;

        public Builder filters(@Nullable JsonValue value) {
            this.filters = value;
            return this;
        }

        public Builder otherBucket(@Nullable Boolean value) {
            this.otherBucket = value;
            return this;
        }

        public Builder otherBucketKey(@Nullable String value) {
            this.otherBucketKey = value;
            return this;
        }

        public Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FiltersAggregation build() {
            return new FiltersAggregation(this);
        }
    }
}

