/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.DateRangeExpression;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DateRangeAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final String field;
    @Nullable
    private final String format;
    @Nullable
    private final String missing;
    @Nullable
    private final List<DateRangeExpression> ranges;
    @Nullable
    private final String timeZone;
    @Nullable
    private final Boolean keyed;
    public static final JsonpDeserializer<DateRangeAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateRangeAggregation::setupDateRangeAggregationDeserializer, Builder::build);

    public DateRangeAggregation(Builder builder) {
        super(builder);
        this.field = builder.field;
        this.format = builder.format;
        this.missing = builder.missing;
        this.ranges = ModelTypeHelper.unmodifiable(builder.ranges);
        this.timeZone = builder.timeZone;
        this.keyed = builder.keyed;
    }

    public DateRangeAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "date_range";
    }

    @Nullable
    public String field() {
        return this.field;
    }

    @Nullable
    public String format() {
        return this.format;
    }

    @Nullable
    public String missing() {
        return this.missing;
    }

    @Nullable
    public List<DateRangeExpression> ranges() {
        return this.ranges;
    }

    @Nullable
    public String timeZone() {
        return this.timeZone;
    }

    @Nullable
    public Boolean keyed() {
        return this.keyed;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.write(this.missing);
        }
        if (this.ranges != null) {
            generator.writeKey("ranges");
            generator.writeStartArray();
            for (DateRangeExpression item0 : this.ranges) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed.booleanValue());
        }
    }

    protected static void setupDateRangeAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format", new String[0]);
        op.add(Builder::missing, JsonpDeserializer.stringDeserializer(), "missing", new String[0]);
        op.add(Builder::ranges, JsonpDeserializer.arrayDeserializer(DateRangeExpression._DESERIALIZER), "ranges", new String[0]);
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone", new String[0]);
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed", new String[0]);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DateRangeAggregation> {
        @Nullable
        private String field;
        @Nullable
        private String format;
        @Nullable
        private String missing;
        @Nullable
        private List<DateRangeExpression> ranges;
        @Nullable
        private String timeZone;
        @Nullable
        private Boolean keyed;

        public Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public Builder missing(@Nullable String value) {
            this.missing = value;
            return this;
        }

        public Builder ranges(@Nullable List<DateRangeExpression> value) {
            this.ranges = value;
            return this;
        }

        public Builder ranges(DateRangeExpression ... value) {
            this.ranges = Arrays.asList(value);
            return this;
        }

        public Builder addRanges(DateRangeExpression value) {
            if (this.ranges == null) {
                this.ranges = new ArrayList<DateRangeExpression>();
            }
            this.ranges.add(value);
            return this;
        }

        public Builder ranges(Function<DateRangeExpression.Builder, ObjectBuilder<DateRangeExpression>> fn) {
            return this.ranges(fn.apply(new DateRangeExpression.Builder()).build());
        }

        public Builder addRanges(Function<DateRangeExpression.Builder, ObjectBuilder<DateRangeExpression>> fn) {
            return this.addRanges(fn.apply(new DateRangeExpression.Builder()).build());
        }

        public Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        public Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DateRangeAggregation build() {
            return new DateRangeAggregation(this);
        }
    }
}

