/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.MinimumInterval;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AutoDateHistogramAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final Integer buckets;
    @Nullable
    private final String field;
    @Nullable
    private final String format;
    @Nullable
    private final MinimumInterval minimumInterval;
    @Nullable
    private final String missing;
    @Nullable
    private final String offset;
    @Nullable
    private final Map<String, JsonData> params;
    @Nullable
    private final JsonValue script;
    @Nullable
    private final String timeZone;
    public static final JsonpDeserializer<AutoDateHistogramAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AutoDateHistogramAggregation::setupAutoDateHistogramAggregationDeserializer, Builder::build);

    public AutoDateHistogramAggregation(Builder builder) {
        super(builder);
        this.buckets = builder.buckets;
        this.field = builder.field;
        this.format = builder.format;
        this.minimumInterval = builder.minimumInterval;
        this.missing = builder.missing;
        this.offset = builder.offset;
        this.params = ModelTypeHelper.unmodifiable(builder.params);
        this.script = builder.script;
        this.timeZone = builder.timeZone;
    }

    public AutoDateHistogramAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "auto_date_histogram";
    }

    @Nullable
    public Integer buckets() {
        return this.buckets;
    }

    @Nullable
    public String field() {
        return this.field;
    }

    @Nullable
    public String format() {
        return this.format;
    }

    @Nullable
    public MinimumInterval minimumInterval() {
        return this.minimumInterval;
    }

    @Nullable
    public String missing() {
        return this.missing;
    }

    @Nullable
    public String offset() {
        return this.offset;
    }

    @Nullable
    public Map<String, JsonData> params() {
        return this.params;
    }

    @Nullable
    public JsonValue script() {
        return this.script;
    }

    @Nullable
    public String timeZone() {
        return this.timeZone;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.buckets != null) {
            generator.writeKey("buckets");
            generator.write(this.buckets.intValue());
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.minimumInterval != null) {
            generator.writeKey("minimum_interval");
            this.minimumInterval.serialize(generator, mapper);
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.write(this.missing);
        }
        if (this.offset != null) {
            generator.writeKey("offset");
            generator.write(this.offset);
        }
        if (this.params != null) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.script != null) {
            generator.writeKey("script");
            generator.write(this.script);
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
    }

    protected static void setupAutoDateHistogramAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::buckets, JsonpDeserializer.integerDeserializer(), "buckets", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format", new String[0]);
        op.add(Builder::minimumInterval, MinimumInterval._DESERIALIZER, "minimum_interval", new String[0]);
        op.add(Builder::missing, JsonpDeserializer.stringDeserializer(), "missing", new String[0]);
        op.add(Builder::offset, JsonpDeserializer.stringDeserializer(), "offset", new String[0]);
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params", new String[0]);
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), "script", new String[0]);
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone", new String[0]);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AutoDateHistogramAggregation> {
        @Nullable
        private Integer buckets;
        @Nullable
        private String field;
        @Nullable
        private String format;
        @Nullable
        private MinimumInterval minimumInterval;
        @Nullable
        private String missing;
        @Nullable
        private String offset;
        @Nullable
        private Map<String, JsonData> params;
        @Nullable
        private JsonValue script;
        @Nullable
        private String timeZone;

        public Builder buckets(@Nullable Integer value) {
            this.buckets = value;
            return this;
        }

        public Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public Builder minimumInterval(@Nullable MinimumInterval value) {
            this.minimumInterval = value;
            return this;
        }

        public Builder missing(@Nullable String value) {
            this.missing = value;
            return this;
        }

        public Builder offset(@Nullable String value) {
            this.offset = value;
            return this;
        }

        public Builder params(@Nullable Map<String, JsonData> value) {
            this.params = value;
            return this;
        }

        public Builder putParams(String key, JsonData value) {
            if (this.params == null) {
                this.params = new HashMap<String, JsonData>();
            }
            this.params.put(key, value);
            return this;
        }

        public Builder script(@Nullable JsonValue value) {
            this.script = value;
            return this;
        }

        public Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AutoDateHistogramAggregation build() {
            return new AutoDateHistogramAggregation(this);
        }
    }
}

