/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

public abstract class ShardsOperationResponseBase
implements JsonpSerializable {
    private final ShardStatistics shards;

    public ShardsOperationResponseBase(AbstractBuilder<?> builder) {
        this.shards = Objects.requireNonNull(((AbstractBuilder)builder).shards, "_shards");
    }

    public ShardStatistics shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupShardsOperationResponseBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::shards, ShardStatistics._DESERIALIZER, "_shards", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        private ShardStatistics shards;

        protected AbstractBuilder() {
        }

        public BuilderT shards(ShardStatistics value) {
            this.shards = value;
            return this.self();
        }

        public BuilderT shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        protected abstract BuilderT self();
    }
}

