/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch.indices.stats.ShardFileSizeInfo;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SegmentsStats
implements JsonpSerializable {
    private final int count;
    @Nullable
    private final String docValuesMemory;
    private final int docValuesMemoryInBytes;
    private final Map<String, ShardFileSizeInfo> fileSizes;
    @Nullable
    private final String fixedBitSet;
    private final int fixedBitSetMemoryInBytes;
    @Nullable
    private final String indexWriterMemory;
    @Nullable
    private final Integer indexWriterMaxMemoryInBytes;
    private final int indexWriterMemoryInBytes;
    private final int maxUnsafeAutoIdTimestamp;
    @Nullable
    private final String memory;
    private final int memoryInBytes;
    @Nullable
    private final String normsMemory;
    private final int normsMemoryInBytes;
    @Nullable
    private final String pointsMemory;
    private final int pointsMemoryInBytes;
    @Nullable
    private final String storedMemory;
    private final int storedFieldsMemoryInBytes;
    private final int termsMemoryInBytes;
    @Nullable
    private final String termsMemory;
    @Nullable
    private final String termVectoryMemory;
    private final int termVectorsMemoryInBytes;
    @Nullable
    private final String versionMapMemory;
    private final int versionMapMemoryInBytes;
    public static final JsonpDeserializer<SegmentsStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SegmentsStats::setupSegmentsStatsDeserializer, Builder::build);

    public SegmentsStats(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.docValuesMemory = builder.docValuesMemory;
        this.docValuesMemoryInBytes = Objects.requireNonNull(builder.docValuesMemoryInBytes, "doc_values_memory_in_bytes");
        this.fileSizes = ModelTypeHelper.unmodifiableNonNull(builder.fileSizes, "file_sizes");
        this.fixedBitSet = builder.fixedBitSet;
        this.fixedBitSetMemoryInBytes = Objects.requireNonNull(builder.fixedBitSetMemoryInBytes, "fixed_bit_set_memory_in_bytes");
        this.indexWriterMemory = builder.indexWriterMemory;
        this.indexWriterMaxMemoryInBytes = builder.indexWriterMaxMemoryInBytes;
        this.indexWriterMemoryInBytes = Objects.requireNonNull(builder.indexWriterMemoryInBytes, "index_writer_memory_in_bytes");
        this.maxUnsafeAutoIdTimestamp = Objects.requireNonNull(builder.maxUnsafeAutoIdTimestamp, "max_unsafe_auto_id_timestamp");
        this.memory = builder.memory;
        this.memoryInBytes = Objects.requireNonNull(builder.memoryInBytes, "memory_in_bytes");
        this.normsMemory = builder.normsMemory;
        this.normsMemoryInBytes = Objects.requireNonNull(builder.normsMemoryInBytes, "norms_memory_in_bytes");
        this.pointsMemory = builder.pointsMemory;
        this.pointsMemoryInBytes = Objects.requireNonNull(builder.pointsMemoryInBytes, "points_memory_in_bytes");
        this.storedMemory = builder.storedMemory;
        this.storedFieldsMemoryInBytes = Objects.requireNonNull(builder.storedFieldsMemoryInBytes, "stored_fields_memory_in_bytes");
        this.termsMemoryInBytes = Objects.requireNonNull(builder.termsMemoryInBytes, "terms_memory_in_bytes");
        this.termsMemory = builder.termsMemory;
        this.termVectoryMemory = builder.termVectoryMemory;
        this.termVectorsMemoryInBytes = Objects.requireNonNull(builder.termVectorsMemoryInBytes, "term_vectors_memory_in_bytes");
        this.versionMapMemory = builder.versionMapMemory;
        this.versionMapMemoryInBytes = Objects.requireNonNull(builder.versionMapMemoryInBytes, "version_map_memory_in_bytes");
    }

    public SegmentsStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int count() {
        return this.count;
    }

    @Nullable
    public String docValuesMemory() {
        return this.docValuesMemory;
    }

    public int docValuesMemoryInBytes() {
        return this.docValuesMemoryInBytes;
    }

    public Map<String, ShardFileSizeInfo> fileSizes() {
        return this.fileSizes;
    }

    @Nullable
    public String fixedBitSet() {
        return this.fixedBitSet;
    }

    public int fixedBitSetMemoryInBytes() {
        return this.fixedBitSetMemoryInBytes;
    }

    @Nullable
    public String indexWriterMemory() {
        return this.indexWriterMemory;
    }

    @Nullable
    public Integer indexWriterMaxMemoryInBytes() {
        return this.indexWriterMaxMemoryInBytes;
    }

    public int indexWriterMemoryInBytes() {
        return this.indexWriterMemoryInBytes;
    }

    public int maxUnsafeAutoIdTimestamp() {
        return this.maxUnsafeAutoIdTimestamp;
    }

    @Nullable
    public String memory() {
        return this.memory;
    }

    public int memoryInBytes() {
        return this.memoryInBytes;
    }

    @Nullable
    public String normsMemory() {
        return this.normsMemory;
    }

    public int normsMemoryInBytes() {
        return this.normsMemoryInBytes;
    }

    @Nullable
    public String pointsMemory() {
        return this.pointsMemory;
    }

    public int pointsMemoryInBytes() {
        return this.pointsMemoryInBytes;
    }

    @Nullable
    public String storedMemory() {
        return this.storedMemory;
    }

    public int storedFieldsMemoryInBytes() {
        return this.storedFieldsMemoryInBytes;
    }

    public int termsMemoryInBytes() {
        return this.termsMemoryInBytes;
    }

    @Nullable
    public String termsMemory() {
        return this.termsMemory;
    }

    @Nullable
    public String termVectoryMemory() {
        return this.termVectoryMemory;
    }

    public int termVectorsMemoryInBytes() {
        return this.termVectorsMemoryInBytes;
    }

    @Nullable
    public String versionMapMemory() {
        return this.versionMapMemory;
    }

    public int versionMapMemoryInBytes() {
        return this.versionMapMemoryInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (this.docValuesMemory != null) {
            generator.writeKey("doc_values_memory");
            generator.write(this.docValuesMemory);
        }
        generator.writeKey("doc_values_memory_in_bytes");
        generator.write(this.docValuesMemoryInBytes);
        generator.writeKey("file_sizes");
        generator.writeStartObject();
        for (Map.Entry<String, ShardFileSizeInfo> item0 : this.fileSizes.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.fixedBitSet != null) {
            generator.writeKey("fixed_bit_set");
            generator.write(this.fixedBitSet);
        }
        generator.writeKey("fixed_bit_set_memory_in_bytes");
        generator.write(this.fixedBitSetMemoryInBytes);
        if (this.indexWriterMemory != null) {
            generator.writeKey("index_writer_memory");
            generator.write(this.indexWriterMemory);
        }
        if (this.indexWriterMaxMemoryInBytes != null) {
            generator.writeKey("index_writer_max_memory_in_bytes");
            generator.write(this.indexWriterMaxMemoryInBytes.intValue());
        }
        generator.writeKey("index_writer_memory_in_bytes");
        generator.write(this.indexWriterMemoryInBytes);
        generator.writeKey("max_unsafe_auto_id_timestamp");
        generator.write(this.maxUnsafeAutoIdTimestamp);
        if (this.memory != null) {
            generator.writeKey("memory");
            generator.write(this.memory);
        }
        generator.writeKey("memory_in_bytes");
        generator.write(this.memoryInBytes);
        if (this.normsMemory != null) {
            generator.writeKey("norms_memory");
            generator.write(this.normsMemory);
        }
        generator.writeKey("norms_memory_in_bytes");
        generator.write(this.normsMemoryInBytes);
        if (this.pointsMemory != null) {
            generator.writeKey("points_memory");
            generator.write(this.pointsMemory);
        }
        generator.writeKey("points_memory_in_bytes");
        generator.write(this.pointsMemoryInBytes);
        if (this.storedMemory != null) {
            generator.writeKey("stored_memory");
            generator.write(this.storedMemory);
        }
        generator.writeKey("stored_fields_memory_in_bytes");
        generator.write(this.storedFieldsMemoryInBytes);
        generator.writeKey("terms_memory_in_bytes");
        generator.write(this.termsMemoryInBytes);
        if (this.termsMemory != null) {
            generator.writeKey("terms_memory");
            generator.write(this.termsMemory);
        }
        if (this.termVectoryMemory != null) {
            generator.writeKey("term_vectory_memory");
            generator.write(this.termVectoryMemory);
        }
        generator.writeKey("term_vectors_memory_in_bytes");
        generator.write(this.termVectorsMemoryInBytes);
        if (this.versionMapMemory != null) {
            generator.writeKey("version_map_memory");
            generator.write(this.versionMapMemory);
        }
        generator.writeKey("version_map_memory_in_bytes");
        generator.write(this.versionMapMemoryInBytes);
    }

    protected static void setupSegmentsStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count", new String[0]);
        op.add(Builder::docValuesMemory, JsonpDeserializer.stringDeserializer(), "doc_values_memory", new String[0]);
        op.add(Builder::docValuesMemoryInBytes, JsonpDeserializer.integerDeserializer(), "doc_values_memory_in_bytes", new String[0]);
        op.add(Builder::fileSizes, JsonpDeserializer.stringMapDeserializer(ShardFileSizeInfo._DESERIALIZER), "file_sizes", new String[0]);
        op.add(Builder::fixedBitSet, JsonpDeserializer.stringDeserializer(), "fixed_bit_set", new String[0]);
        op.add(Builder::fixedBitSetMemoryInBytes, JsonpDeserializer.integerDeserializer(), "fixed_bit_set_memory_in_bytes", new String[0]);
        op.add(Builder::indexWriterMemory, JsonpDeserializer.stringDeserializer(), "index_writer_memory", new String[0]);
        op.add(Builder::indexWriterMaxMemoryInBytes, JsonpDeserializer.integerDeserializer(), "index_writer_max_memory_in_bytes", new String[0]);
        op.add(Builder::indexWriterMemoryInBytes, JsonpDeserializer.integerDeserializer(), "index_writer_memory_in_bytes", new String[0]);
        op.add(Builder::maxUnsafeAutoIdTimestamp, JsonpDeserializer.integerDeserializer(), "max_unsafe_auto_id_timestamp", new String[0]);
        op.add(Builder::memory, JsonpDeserializer.stringDeserializer(), "memory", new String[0]);
        op.add(Builder::memoryInBytes, JsonpDeserializer.integerDeserializer(), "memory_in_bytes", new String[0]);
        op.add(Builder::normsMemory, JsonpDeserializer.stringDeserializer(), "norms_memory", new String[0]);
        op.add(Builder::normsMemoryInBytes, JsonpDeserializer.integerDeserializer(), "norms_memory_in_bytes", new String[0]);
        op.add(Builder::pointsMemory, JsonpDeserializer.stringDeserializer(), "points_memory", new String[0]);
        op.add(Builder::pointsMemoryInBytes, JsonpDeserializer.integerDeserializer(), "points_memory_in_bytes", new String[0]);
        op.add(Builder::storedMemory, JsonpDeserializer.stringDeserializer(), "stored_memory", new String[0]);
        op.add(Builder::storedFieldsMemoryInBytes, JsonpDeserializer.integerDeserializer(), "stored_fields_memory_in_bytes", new String[0]);
        op.add(Builder::termsMemoryInBytes, JsonpDeserializer.integerDeserializer(), "terms_memory_in_bytes", new String[0]);
        op.add(Builder::termsMemory, JsonpDeserializer.stringDeserializer(), "terms_memory", new String[0]);
        op.add(Builder::termVectoryMemory, JsonpDeserializer.stringDeserializer(), "term_vectory_memory", new String[0]);
        op.add(Builder::termVectorsMemoryInBytes, JsonpDeserializer.integerDeserializer(), "term_vectors_memory_in_bytes", new String[0]);
        op.add(Builder::versionMapMemory, JsonpDeserializer.stringDeserializer(), "version_map_memory", new String[0]);
        op.add(Builder::versionMapMemoryInBytes, JsonpDeserializer.integerDeserializer(), "version_map_memory_in_bytes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SegmentsStats> {
        private Integer count;
        @Nullable
        private String docValuesMemory;
        private Integer docValuesMemoryInBytes;
        private Map<String, ShardFileSizeInfo> fileSizes;
        @Nullable
        private String fixedBitSet;
        private Integer fixedBitSetMemoryInBytes;
        @Nullable
        private String indexWriterMemory;
        @Nullable
        private Integer indexWriterMaxMemoryInBytes;
        private Integer indexWriterMemoryInBytes;
        private Integer maxUnsafeAutoIdTimestamp;
        @Nullable
        private String memory;
        private Integer memoryInBytes;
        @Nullable
        private String normsMemory;
        private Integer normsMemoryInBytes;
        @Nullable
        private String pointsMemory;
        private Integer pointsMemoryInBytes;
        @Nullable
        private String storedMemory;
        private Integer storedFieldsMemoryInBytes;
        private Integer termsMemoryInBytes;
        @Nullable
        private String termsMemory;
        @Nullable
        private String termVectoryMemory;
        private Integer termVectorsMemoryInBytes;
        @Nullable
        private String versionMapMemory;
        private Integer versionMapMemoryInBytes;

        public Builder count(int value) {
            this.count = value;
            return this;
        }

        public Builder docValuesMemory(@Nullable String value) {
            this.docValuesMemory = value;
            return this;
        }

        public Builder docValuesMemoryInBytes(int value) {
            this.docValuesMemoryInBytes = value;
            return this;
        }

        public Builder fileSizes(Map<String, ShardFileSizeInfo> value) {
            this.fileSizes = value;
            return this;
        }

        public Builder putFileSizes(String key, ShardFileSizeInfo value) {
            if (this.fileSizes == null) {
                this.fileSizes = new HashMap<String, ShardFileSizeInfo>();
            }
            this.fileSizes.put(key, value);
            return this;
        }

        public Builder fileSizes(String key, Function<ShardFileSizeInfo.Builder, ObjectBuilder<ShardFileSizeInfo>> fn) {
            return this.fileSizes(Collections.singletonMap(key, fn.apply(new ShardFileSizeInfo.Builder()).build()));
        }

        public Builder putFileSizes(String key, Function<ShardFileSizeInfo.Builder, ObjectBuilder<ShardFileSizeInfo>> fn) {
            return this.putFileSizes(key, fn.apply(new ShardFileSizeInfo.Builder()).build());
        }

        public Builder fixedBitSet(@Nullable String value) {
            this.fixedBitSet = value;
            return this;
        }

        public Builder fixedBitSetMemoryInBytes(int value) {
            this.fixedBitSetMemoryInBytes = value;
            return this;
        }

        public Builder indexWriterMemory(@Nullable String value) {
            this.indexWriterMemory = value;
            return this;
        }

        public Builder indexWriterMaxMemoryInBytes(@Nullable Integer value) {
            this.indexWriterMaxMemoryInBytes = value;
            return this;
        }

        public Builder indexWriterMemoryInBytes(int value) {
            this.indexWriterMemoryInBytes = value;
            return this;
        }

        public Builder maxUnsafeAutoIdTimestamp(int value) {
            this.maxUnsafeAutoIdTimestamp = value;
            return this;
        }

        public Builder memory(@Nullable String value) {
            this.memory = value;
            return this;
        }

        public Builder memoryInBytes(int value) {
            this.memoryInBytes = value;
            return this;
        }

        public Builder normsMemory(@Nullable String value) {
            this.normsMemory = value;
            return this;
        }

        public Builder normsMemoryInBytes(int value) {
            this.normsMemoryInBytes = value;
            return this;
        }

        public Builder pointsMemory(@Nullable String value) {
            this.pointsMemory = value;
            return this;
        }

        public Builder pointsMemoryInBytes(int value) {
            this.pointsMemoryInBytes = value;
            return this;
        }

        public Builder storedMemory(@Nullable String value) {
            this.storedMemory = value;
            return this;
        }

        public Builder storedFieldsMemoryInBytes(int value) {
            this.storedFieldsMemoryInBytes = value;
            return this;
        }

        public Builder termsMemoryInBytes(int value) {
            this.termsMemoryInBytes = value;
            return this;
        }

        public Builder termsMemory(@Nullable String value) {
            this.termsMemory = value;
            return this;
        }

        public Builder termVectoryMemory(@Nullable String value) {
            this.termVectoryMemory = value;
            return this;
        }

        public Builder termVectorsMemoryInBytes(int value) {
            this.termVectorsMemoryInBytes = value;
            return this;
        }

        public Builder versionMapMemory(@Nullable String value) {
            this.versionMapMemory = value;
            return this;
        }

        public Builder versionMapMemoryInBytes(int value) {
            this.versionMapMemoryInBytes = value;
            return this;
        }

        @Override
        public SegmentsStats build() {
            return new SegmentsStats(this);
        }
    }
}

