/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class PluginStats
implements JsonpSerializable {
    private final String classname;
    private final String description;
    private final String elasticsearchVersion;
    private final List<String> extendedPlugins;
    private final boolean hasNativeController;
    private final String javaVersion;
    private final String name;
    private final String version;
    private final boolean licensed;
    private final String type;
    public static final JsonpDeserializer<PluginStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PluginStats::setupPluginStatsDeserializer, Builder::build);

    public PluginStats(Builder builder) {
        this.classname = Objects.requireNonNull(builder.classname, "classname");
        this.description = Objects.requireNonNull(builder.description, "description");
        this.elasticsearchVersion = Objects.requireNonNull(builder.elasticsearchVersion, "elasticsearch_version");
        this.extendedPlugins = ModelTypeHelper.unmodifiableNonNull(builder.extendedPlugins, "extended_plugins");
        this.hasNativeController = Objects.requireNonNull(builder.hasNativeController, "has_native_controller");
        this.javaVersion = Objects.requireNonNull(builder.javaVersion, "java_version");
        this.name = Objects.requireNonNull(builder.name, "name");
        this.version = Objects.requireNonNull(builder.version, "version");
        this.licensed = Objects.requireNonNull(builder.licensed, "licensed");
        this.type = Objects.requireNonNull(builder.type, "type");
    }

    public PluginStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String classname() {
        return this.classname;
    }

    public String description() {
        return this.description;
    }

    public String elasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public List<String> extendedPlugins() {
        return this.extendedPlugins;
    }

    public boolean hasNativeController() {
        return this.hasNativeController;
    }

    public String javaVersion() {
        return this.javaVersion;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public boolean licensed() {
        return this.licensed;
    }

    public String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("classname");
        generator.write(this.classname);
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("elasticsearch_version");
        generator.write(this.elasticsearchVersion);
        generator.writeKey("extended_plugins");
        generator.writeStartArray();
        for (String item0 : this.extendedPlugins) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("has_native_controller");
        generator.write(this.hasNativeController);
        generator.writeKey("java_version");
        generator.write(this.javaVersion);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("licensed");
        generator.write(this.licensed);
        generator.writeKey("type");
        generator.write(this.type);
    }

    protected static void setupPluginStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::classname, JsonpDeserializer.stringDeserializer(), "classname", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::elasticsearchVersion, JsonpDeserializer.stringDeserializer(), "elasticsearch_version", new String[0]);
        op.add(Builder::extendedPlugins, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "extended_plugins", new String[0]);
        op.add(Builder::hasNativeController, JsonpDeserializer.booleanDeserializer(), "has_native_controller", new String[0]);
        op.add(Builder::javaVersion, JsonpDeserializer.stringDeserializer(), "java_version", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version", new String[0]);
        op.add(Builder::licensed, JsonpDeserializer.booleanDeserializer(), "licensed", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PluginStats> {
        private String classname;
        private String description;
        private String elasticsearchVersion;
        private List<String> extendedPlugins;
        private Boolean hasNativeController;
        private String javaVersion;
        private String name;
        private String version;
        private Boolean licensed;
        private String type;

        public Builder classname(String value) {
            this.classname = value;
            return this;
        }

        public Builder description(String value) {
            this.description = value;
            return this;
        }

        public Builder elasticsearchVersion(String value) {
            this.elasticsearchVersion = value;
            return this;
        }

        public Builder extendedPlugins(List<String> value) {
            this.extendedPlugins = value;
            return this;
        }

        public Builder extendedPlugins(String ... value) {
            this.extendedPlugins = Arrays.asList(value);
            return this;
        }

        public Builder addExtendedPlugins(String value) {
            if (this.extendedPlugins == null) {
                this.extendedPlugins = new ArrayList<String>();
            }
            this.extendedPlugins.add(value);
            return this;
        }

        public Builder hasNativeController(boolean value) {
            this.hasNativeController = value;
            return this;
        }

        public Builder javaVersion(String value) {
            this.javaVersion = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder version(String value) {
            this.version = value;
            return this;
        }

        public Builder licensed(boolean value) {
            this.licensed = value;
            return this;
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        public PluginStats build() {
            return new PluginStats(this);
        }
    }
}

