/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class LatLon
implements JsonpSerializable {
    private final double lat;
    private final double lon;
    public static final JsonpDeserializer<LatLon> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LatLon::setupLatLonDeserializer, Builder::build);

    public LatLon(Builder builder) {
        this.lat = Objects.requireNonNull(builder.lat, "lat");
        this.lon = Objects.requireNonNull(builder.lon, "lon");
    }

    public LatLon(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public double lat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("lat");
        generator.write(this.lat);
        generator.writeKey("lon");
        generator.write(this.lon);
    }

    protected static void setupLatLonDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::lat, JsonpDeserializer.doubleDeserializer(), "lat", new String[0]);
        op.add(Builder::lon, JsonpDeserializer.doubleDeserializer(), "lon", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<LatLon> {
        private Double lat;
        private Double lon;

        public Builder lat(double value) {
            this.lat = value;
            return this;
        }

        public Builder lon(double value) {
            this.lon = value;
            return this;
        }

        @Override
        public LatLon build() {
            return new LatLon(this);
        }
    }
}

