/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FieldSizeUsage
implements JsonpSerializable {
    @Nullable
    private final String size;
    private final long sizeInBytes;
    public static final JsonpDeserializer<FieldSizeUsage> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldSizeUsage::setupFieldSizeUsageDeserializer, Builder::build);

    public FieldSizeUsage(Builder builder) {
        this.size = builder.size;
        this.sizeInBytes = Objects.requireNonNull(builder.sizeInBytes, "size_in_bytes");
    }

    public FieldSizeUsage(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String size() {
        return this.size;
    }

    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
    }

    protected static void setupFieldSizeUsageDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::size, JsonpDeserializer.stringDeserializer(), "size", new String[0]);
        op.add(Builder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FieldSizeUsage> {
        @Nullable
        private String size;
        private Long sizeInBytes;

        public Builder size(@Nullable String value) {
            this.size = value;
            return this;
        }

        public Builder sizeInBytes(long value) {
            this.sizeInBytes = value;
            return this;
        }

        @Override
        public FieldSizeUsage build() {
            return new FieldSizeUsage(this);
        }
    }
}

