/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;

public abstract class AcknowledgedResponseBase
implements JsonpSerializable {
    private final boolean acknowledged;

    public AcknowledgedResponseBase(AbstractBuilder<?> builder) {
        this.acknowledged = Objects.requireNonNull(((AbstractBuilder)builder).acknowledged, "acknowledged");
    }

    public boolean acknowledged() {
        return this.acknowledged;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("acknowledged");
        generator.write(this.acknowledged);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupAcknowledgedResponseBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::acknowledged, JsonpDeserializer.booleanDeserializer(), "acknowledged", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        private Boolean acknowledged;

        protected AbstractBuilder() {
        }

        public BuilderT acknowledged(boolean value) {
            this.acknowledged = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

