/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.search;

import co.elastic.clients.elasticsearch._core.search.StringDistance;
import co.elastic.clients.elasticsearch._core.search.SuggestSort;
import co.elastic.clients.elasticsearch._core.search.SuggestVariant;
import co.elastic.clients.elasticsearch._core.search.SuggesterBase;
import co.elastic.clients.elasticsearch._types.SuggestMode;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TermSuggester
extends SuggesterBase
implements SuggestVariant {
    @Nullable
    private final Boolean lowercaseTerms;
    @Nullable
    private final Integer maxEdits;
    @Nullable
    private final Integer maxInspections;
    @Nullable
    private final Float maxTermFreq;
    @Nullable
    private final Float minDocFreq;
    @Nullable
    private final Integer minWordLength;
    @Nullable
    private final Integer prefixLength;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final SuggestSort sort;
    @Nullable
    private final StringDistance stringDistance;
    @Nullable
    private final SuggestMode suggestMode;
    @Nullable
    private final String text;
    public static final JsonpDeserializer<TermSuggester> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermSuggester::setupTermSuggesterDeserializer, Builder::build);

    public TermSuggester(Builder builder) {
        super(builder);
        this.lowercaseTerms = builder.lowercaseTerms;
        this.maxEdits = builder.maxEdits;
        this.maxInspections = builder.maxInspections;
        this.maxTermFreq = builder.maxTermFreq;
        this.minDocFreq = builder.minDocFreq;
        this.minWordLength = builder.minWordLength;
        this.prefixLength = builder.prefixLength;
        this.shardSize = builder.shardSize;
        this.sort = builder.sort;
        this.stringDistance = builder.stringDistance;
        this.suggestMode = builder.suggestMode;
        this.text = builder.text;
    }

    public TermSuggester(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "term";
    }

    @Nullable
    public Boolean lowercaseTerms() {
        return this.lowercaseTerms;
    }

    @Nullable
    public Integer maxEdits() {
        return this.maxEdits;
    }

    @Nullable
    public Integer maxInspections() {
        return this.maxInspections;
    }

    @Nullable
    public Float maxTermFreq() {
        return this.maxTermFreq;
    }

    @Nullable
    public Float minDocFreq() {
        return this.minDocFreq;
    }

    @Nullable
    public Integer minWordLength() {
        return this.minWordLength;
    }

    @Nullable
    public Integer prefixLength() {
        return this.prefixLength;
    }

    @Nullable
    public Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public SuggestSort sort() {
        return this.sort;
    }

    @Nullable
    public StringDistance stringDistance() {
        return this.stringDistance;
    }

    @Nullable
    public SuggestMode suggestMode() {
        return this.suggestMode;
    }

    @Nullable
    public String text() {
        return this.text;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.lowercaseTerms != null) {
            generator.writeKey("lowercase_terms");
            generator.write(this.lowercaseTerms.booleanValue());
        }
        if (this.maxEdits != null) {
            generator.writeKey("max_edits");
            generator.write(this.maxEdits.intValue());
        }
        if (this.maxInspections != null) {
            generator.writeKey("max_inspections");
            generator.write(this.maxInspections.intValue());
        }
        if (this.maxTermFreq != null) {
            generator.writeKey("max_term_freq");
            generator.write((double)this.maxTermFreq.floatValue());
        }
        if (this.minDocFreq != null) {
            generator.writeKey("min_doc_freq");
            generator.write((double)this.minDocFreq.floatValue());
        }
        if (this.minWordLength != null) {
            generator.writeKey("min_word_length");
            generator.write(this.minWordLength.intValue());
        }
        if (this.prefixLength != null) {
            generator.writeKey("prefix_length");
            generator.write(this.prefixLength.intValue());
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
        if (this.sort != null) {
            generator.writeKey("sort");
            this.sort.serialize(generator, mapper);
        }
        if (this.stringDistance != null) {
            generator.writeKey("string_distance");
            this.stringDistance.serialize(generator, mapper);
        }
        if (this.suggestMode != null) {
            generator.writeKey("suggest_mode");
            this.suggestMode.serialize(generator, mapper);
        }
        if (this.text != null) {
            generator.writeKey("text");
            generator.write(this.text);
        }
    }

    protected static void setupTermSuggesterDeserializer(DelegatingDeserializer<Builder> op) {
        SuggesterBase.setupSuggesterBaseDeserializer(op);
        op.add(Builder::lowercaseTerms, JsonpDeserializer.booleanDeserializer(), "lowercase_terms", new String[0]);
        op.add(Builder::maxEdits, JsonpDeserializer.integerDeserializer(), "max_edits", new String[0]);
        op.add(Builder::maxInspections, JsonpDeserializer.integerDeserializer(), "max_inspections", new String[0]);
        op.add(Builder::maxTermFreq, JsonpDeserializer.floatDeserializer(), "max_term_freq", new String[0]);
        op.add(Builder::minDocFreq, JsonpDeserializer.floatDeserializer(), "min_doc_freq", new String[0]);
        op.add(Builder::minWordLength, JsonpDeserializer.integerDeserializer(), "min_word_length", new String[0]);
        op.add(Builder::prefixLength, JsonpDeserializer.integerDeserializer(), "prefix_length", new String[0]);
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size", new String[0]);
        op.add(Builder::sort, SuggestSort._DESERIALIZER, "sort", new String[0]);
        op.add(Builder::stringDistance, StringDistance._DESERIALIZER, "string_distance", new String[0]);
        op.add(Builder::suggestMode, SuggestMode._DESERIALIZER, "suggest_mode", new String[0]);
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text", new String[0]);
    }

    public static class Builder
    extends SuggesterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TermSuggester> {
        @Nullable
        private Boolean lowercaseTerms;
        @Nullable
        private Integer maxEdits;
        @Nullable
        private Integer maxInspections;
        @Nullable
        private Float maxTermFreq;
        @Nullable
        private Float minDocFreq;
        @Nullable
        private Integer minWordLength;
        @Nullable
        private Integer prefixLength;
        @Nullable
        private Integer shardSize;
        @Nullable
        private SuggestSort sort;
        @Nullable
        private StringDistance stringDistance;
        @Nullable
        private SuggestMode suggestMode;
        @Nullable
        private String text;

        public Builder lowercaseTerms(@Nullable Boolean value) {
            this.lowercaseTerms = value;
            return this;
        }

        public Builder maxEdits(@Nullable Integer value) {
            this.maxEdits = value;
            return this;
        }

        public Builder maxInspections(@Nullable Integer value) {
            this.maxInspections = value;
            return this;
        }

        public Builder maxTermFreq(@Nullable Float value) {
            this.maxTermFreq = value;
            return this;
        }

        public Builder minDocFreq(@Nullable Float value) {
            this.minDocFreq = value;
            return this;
        }

        public Builder minWordLength(@Nullable Integer value) {
            this.minWordLength = value;
            return this;
        }

        public Builder prefixLength(@Nullable Integer value) {
            this.prefixLength = value;
            return this;
        }

        public Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        public Builder sort(@Nullable SuggestSort value) {
            this.sort = value;
            return this;
        }

        public Builder stringDistance(@Nullable StringDistance value) {
            this.stringDistance = value;
            return this;
        }

        public Builder suggestMode(@Nullable SuggestMode value) {
            this.suggestMode = value;
            return this;
        }

        public Builder text(@Nullable String value) {
            this.text = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TermSuggester build() {
            return new TermSuggester(this);
        }
    }
}

